/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua;

import com.prosysopc.ua.UaAddressSpace;
import com.prosysopc.ua.nodes.UaDataType;
import com.prosysopc.ua.nodes.UaReference;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.opcfoundation.ua.builtintypes.DateTime;
import org.opcfoundation.ua.builtintypes.ExpandedNodeId;
import org.opcfoundation.ua.builtintypes.LocalizedText;
import org.opcfoundation.ua.builtintypes.NodeId;
import org.opcfoundation.ua.builtintypes.QualifiedName;
import org.opcfoundation.ua.builtintypes.StatusCode;
import org.opcfoundation.ua.builtintypes.Structure;
import org.opcfoundation.ua.builtintypes.UnsignedByte;
import org.opcfoundation.ua.builtintypes.UnsignedInteger;
import org.opcfoundation.ua.builtintypes.UnsignedLong;
import org.opcfoundation.ua.builtintypes.UnsignedShort;
import org.opcfoundation.ua.builtintypes.Variant;
import org.opcfoundation.ua.common.ServiceResultException;
import org.opcfoundation.ua.core.Identifiers;
import org.opcfoundation.ua.core.StatusCodes;
import org.opcfoundation.ua.utils.CryptoUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataTypeConverter {
    private static Logger logger = LoggerFactory.getLogger(DataTypeConverter.class);
    private final UaAddressSpace jd;
    private final Map<Class<?>, Set<UaDataType>> eR = new HashMap();

    public DataTypeConverter(UaAddressSpace object) {
        this.jd = object;
        object = this;
        UaDataType uaDataType = (UaDataType)((DataTypeConverter)object).jd.findNode(Identifiers.BaseDataType);
        super.a(uaDataType, null);
    }

    public Variant convert(Variant object, Class<?> clazz) throws ServiceResultException {
        Object object2;
        block15: {
            Class clazz2;
            block13: {
                int n2;
                block14: {
                    if (object == null || object.getValue() == null) {
                        return new Variant(null);
                    }
                    clazz2 = object.getCompositeClass();
                    if (clazz2.equals(clazz) && object.isArray() == clazz.isArray()) {
                        return object;
                    }
                    object2 = object.getValue();
                    if (!object.isArray()) break block13;
                    int[] nArray = object.getArrayDimensions();
                    if (nArray.length != 1) {
                        throw new ServiceResultException(StatusCodes.Bad_InvalidArgument, "Cannot convert array of dim " + nArray.length);
                    }
                    n2 = Array.getLength(object2);
                    if (clazz.isArray()) break block14;
                    switch (n2) {
                        case 0: {
                            object = null;
                            break block15;
                        }
                        case 1: {
                            object = Array.get(object2, 0);
                            break block15;
                        }
                        default: {
                            throw new ServiceResultException(StatusCodes.Bad_InvalidArgument, "Cannot convert array of length " + n2 + " to scalar");
                        }
                    }
                }
                Class<?> clazz3 = clazz.getComponentType();
                object = Array.newInstance(clazz3, n2);
                for (int i2 = 0; i2 < n2; ++i2) {
                    Object object3 = this.convertValue(Array.get(object2, i2), clazz2, clazz3);
                    Array.set(object, i2, object3);
                }
                break block15;
            }
            if (clazz.isArray()) {
                Class<?> clazz4 = clazz.getComponentType();
                object = Array.newInstance(clazz4, 1);
                Array.set(object, 0, this.convertValue(object2, clazz2, clazz4));
            } else {
                object = this.convertValue(object.getValue(), clazz2, clazz);
            }
        }
        if (object != null) {
            return new Variant(object);
        }
        try {
            return this.parseVariant(object2.toString(), this.getDataTypeForJavaClass(clazz));
        }
        catch (Exception exception) {
            throw new ServiceResultException(StatusCodes.Bad_InvalidArgument, (Throwable)exception);
        }
    }

    public Variant convert(Variant variant, NodeId object) throws ServiceResultException {
        if ((object = this.jd.findNode((NodeId)object)) != null && object instanceof UaDataType) {
            return this.convert(variant, (UaDataType)object);
        }
        return new Variant(null);
    }

    public Variant convert(Variant variant, UaDataType uaDataType) throws ServiceResultException {
        return this.convert(variant, uaDataType.getJavaClass());
    }

    public UaDataType getDataTypeForJavaClass(Class<?> uaDataTypeArray) {
        if ((uaDataTypeArray = this.getDataTypesForJavaClass((Class<?>)uaDataTypeArray)) == null || uaDataTypeArray.length == 0) {
            return null;
        }
        return uaDataTypeArray[0];
    }

    public UaDataType[] getDataTypesForJavaClass(Class<?> clazz) {
        if (clazz == null) {
            return null;
        }
        logger.debug("getDataTypeForJavaClass: {}", clazz);
        while (!clazz.equals(byte[].class) && clazz.isArray()) {
            clazz = clazz.getComponentType();
        }
        Set<Object> set = this.eR.get(clazz);
        if (set == null) {
            if (Structure.class.isAssignableFrom(clazz)) {
                try {
                    Object object;
                    set = clazz;
                    set = (ExpandedNodeId)((Class)((Object)set)).getField("ID").get(null);
                    try {
                        object = this.jd.getNamespaceTable().toNodeId((ExpandedNodeId)set);
                    }
                    catch (ServiceResultException serviceResultException) {
                        throw new IllegalArgumentException("Could not convert ExpandedNodeId " + set + " to NodeId");
                    }
                    object = (UaDataType)this.jd.findNode((NodeId)object);
                    if (object == null) {
                        throw new IllegalArgumentException("Cannot find data type of Structure type " + clazz);
                    }
                    set = new HashSet<NodeId>();
                    set.add(object);
                    this.eR.put(clazz, set);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new IllegalArgumentException("Cannot find data type of Structure type " + clazz, illegalArgumentException);
                }
                catch (SecurityException securityException) {
                    throw new IllegalArgumentException("Cannot find data type of Structure type " + clazz, securityException);
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw new IllegalArgumentException("Cannot find data type of Structure type " + clazz, illegalAccessException);
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    throw new IllegalArgumentException("Cannot find data type of Structure type " + clazz, noSuchFieldException);
                }
            }
            throw new IllegalArgumentException("Cannot find data type of " + clazz);
        }
        return set.toArray(new UaDataType[0]);
    }

    public boolean isNullable(NodeId nodeId) {
        return true;
    }

    public Variant parseVariant(String object, Class<?> clazz) {
        if (object == null) {
            throw new NullPointerException("string is null");
        }
        if (clazz == null) {
            throw new NullPointerException("javaclass is null");
        }
        if (clazz == UnsignedByte.class) {
            object = UnsignedByte.parseUnsignedByte((String)object);
        } else if (clazz == Boolean.class) {
            try {
                object = this.convertValue(object, String.class, Boolean.class);
            }
            catch (ServiceResultException serviceResultException) {
                throw new IllegalArgumentException(serviceResultException);
            }
        } else if (clazz == DateTime.class) {
            try {
                object = DateTime.parseDateTime((String)object);
            }
            catch (ParseException parseException) {
                throw new IllegalArgumentException(parseException);
            }
        } else if (clazz == Double.class) {
            object = Double.parseDouble((String)object);
        } else if (clazz == ExpandedNodeId.class) {
            object = ExpandedNodeId.parseExpandedNodeId((String)object);
        } else if (clazz == Float.class) {
            object = Float.valueOf(Float.parseFloat((String)object));
        } else if (clazz == UUID.class) {
            object = UUID.fromString((String)object);
        } else if (clazz == Short.class) {
            object = Short.parseShort((String)object);
        } else if (clazz == Integer.class) {
            object = Integer.parseInt((String)object);
        } else if (clazz == Long.class) {
            object = Long.parseLong((String)object);
        } else if (clazz == LocalizedText.class) {
            object = new LocalizedText((String)object, "");
        } else if (clazz == NodeId.class) {
            object = NodeId.parseNodeId((String)object);
        } else if (clazz == QualifiedName.class) {
            object = new QualifiedName((String)object);
        } else if (clazz == Byte.class) {
            object = Byte.parseByte((String)object);
        } else if (clazz == UnsignedShort.class) {
            object = UnsignedShort.parseUnsignedShort((String)object);
        } else if (clazz == UnsignedInteger.class) {
            object = UnsignedInteger.parseUnsignedInteger((String)object);
        } else if (clazz == UnsignedLong.class) {
            object = UnsignedLong.parseUnsignedLong((String)object);
        }
        try {
            return new Variant(clazz.cast(object));
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException(numberFormatException);
        }
        catch (ClassCastException classCastException) {
            throw new IllegalArgumentException(classCastException);
        }
    }

    public Variant parseVariant(String string, NodeId object) {
        if ((object = this.jd.findNode((NodeId)object)) != null && object instanceof UaDataType) {
            return this.parseVariant(string, (UaDataType)object);
        }
        return new Variant((Object)string);
    }

    public Variant parseVariant(String string, UaDataType uaDataType) {
        if (uaDataType == null) {
            throw new IllegalArgumentException("dataType is null");
        }
        Class<?> clazz = uaDataType.getJavaClass();
        UaDataType uaDataType2 = uaDataType;
        while (clazz == null) {
            try {
                uaDataType2 = (UaDataType)uaDataType2.getSuperType();
                if (uaDataType2 == null) break;
                clazz = uaDataType2.getJavaClass();
            }
            catch (ClassCastException classCastException) {}
        }
        if (clazz == null) {
            throw new IllegalArgumentException("No Javaclass corresponding to dataType " + uaDataType.getBrowseName());
        }
        return this.parseVariant(string, clazz);
    }

    private void a(UaDataType uaReferenceArray, Class<?> clazz) {
        if (uaReferenceArray != null) {
            for (UaReference uaReference : uaReferenceArray.getReferences(Identifiers.HasSubtype, false)) {
                if (!(uaReference.getTargetNode() instanceof UaDataType)) continue;
                Serializable serializable = clazz;
                UaDataType uaDataType = (UaDataType)uaReference.getTargetNode();
                DataTypeConverter dataTypeConverter = this;
                Class<?> clazz2 = uaDataType.getJavaClass();
                if (clazz2 == null) {
                    clazz2 = serializable;
                }
                if (!dataTypeConverter.eR.containsKey(clazz2)) {
                    serializable = new HashSet<UaDataType>();
                    serializable.add(uaDataType);
                    dataTypeConverter.eR.put(clazz2, (Set<UaDataType>)((Object)serializable));
                } else {
                    dataTypeConverter.eR.get(clazz2).add(uaDataType);
                }
                dataTypeConverter.a(uaDataType, clazz2);
            }
        }
    }

    protected Boolean booleanValue(Object object) throws ServiceResultException {
        if (object == null) {
            return null;
        }
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        if (object instanceof Number) {
            return ((Number)object).longValue() != 0L;
        }
        if (object instanceof String) {
            if (((String)(object = ((String)object).toLowerCase())).equals("true") || ((String)object).equals("1")) {
                return true;
            }
            if (((String)object).equals("false") || ((String)object).equals("0")) {
                return false;
            }
            throw new ServiceResultException(StatusCodes.Bad_InvalidArgument, "String value '" + (String)object + "' cannot be cast to boolean");
        }
        return (Boolean)object;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Object convertValue(Object object, Class<?> clazz, Class<?> clazz2) throws ServiceResultException {
        if (object == null) {
            return null;
        }
        Object object2 = null;
        if (object instanceof Variant) {
            object2 = this.convertVariant((Variant)object, clazz, clazz2);
        }
        if (object2 != null) return object2;
        if (clazz2.equals(Boolean.class)) {
            return this.booleanValue(object);
        }
        if (clazz.equals(byte[].class) && clazz2.equals(String.class)) {
            return CryptoUtil.toHex((byte[])((byte[])object));
        }
        if (clazz.equals(LocalizedText.class) && clazz2.equals(String.class)) {
            return ((LocalizedText)object).getText();
        }
        if (clazz.equals(String.class) && clazz2.equals(LocalizedText.class)) {
            return new LocalizedText((String)object, LocalizedText.NO_LOCALE);
        }
        if (clazz.equals(QualifiedName.class) && clazz2.equals(String.class)) {
            return ((QualifiedName)object).getName();
        }
        if (clazz.equals(String.class) && clazz2.equals(QualifiedName.class)) {
            return new QualifiedName((String)object);
        }
        if (clazz.equals(StatusCode.class)) {
            StatusCode statusCode = (StatusCode)object;
            int n2 = statusCode.getValueAsIntBits();
            if (clazz2.equals(UnsignedInteger.class)) {
                return UnsignedInteger.getFromBits((int)n2);
            }
            if (clazz2.equals(Integer.class)) {
                return n2;
            }
            if (clazz2.equals(UnsignedShort.class)) {
                return new UnsignedShort(n2 >> 16);
            }
            if (!clazz2.equals(Short.class)) throw new ServiceResultException(StatusCodes.Bad_InvalidArgument, "Cannot convert StatusCode to " + clazz2);
            return n2 >> 16;
        }
        if (clazz2.equals(String.class)) {
            return object.toString();
        }
        try {
            Number number = this.toNumber(object, clazz2);
            long l2 = number.longValue();
            logger.debug("convertValue: number={}", (Object)number);
            logger.debug("convertValue: longValue={}", (Object)number);
            if (clazz2.equals(StatusCode.class)) {
                if (clazz.equals(UnsignedInteger.class)) return StatusCode.getFromBits((int)number.intValue());
                if (clazz.equals(Integer.class)) {
                    return StatusCode.getFromBits((int)number.intValue());
                }
                if (clazz.equals(UnsignedShort.class)) return StatusCode.getFromBits((int)(number.shortValue() << 16));
                if (!clazz.equals(Short.class)) return object2;
                return StatusCode.getFromBits((int)(number.shortValue() << 16));
            }
            object2 = null;
            if (clazz2.equals(UnsignedInteger.class)) {
                object2 = UnsignedInteger.valueOf((long)l2);
            } else if (clazz2.equals(UnsignedShort.class)) {
                object2 = UnsignedShort.valueOf((int)((int)l2));
            } else if (clazz2.equals(UnsignedByte.class)) {
                object2 = UnsignedByte.valueOf((int)((int)l2));
            } else {
                if (clazz2.equals(UnsignedLong.class)) {
                    if (clazz.equals(Float.class)) return new UnsignedLong(BigDecimal.valueOf(number.doubleValue()).toBigInteger());
                    if (!clazz.equals(Double.class)) return UnsignedLong.valueOf((long)l2);
                    return new UnsignedLong(BigDecimal.valueOf(number.doubleValue()).toBigInteger());
                }
                if (clazz2.equals(Integer.class)) {
                    object2 = number.intValue();
                } else if (clazz2.equals(Short.class)) {
                    object2 = number.shortValue();
                } else if (clazz2.equals(Byte.class)) {
                    object2 = number.byteValue();
                } else if (clazz2.equals(Long.class)) {
                    object2 = l2;
                } else {
                    if (clazz2.equals(Double.class)) {
                        return number.doubleValue();
                    }
                    if (clazz2.equals(Float.class)) {
                        return Float.valueOf(number.floatValue());
                    }
                }
            }
            logger.debug("convertValue: n={}", object2);
            if (object2 != null) {
                logger.debug("convertValue: n.longValue={}", (Object)((Number)object2).longValue());
            }
            if (object2 == null) throw new ServiceResultException(StatusCodes.Bad_InvalidArgument, "Cannot convert " + object + " to " + clazz2);
            if (((Number)object2).longValue() == l2) return object2;
            throw new ServiceResultException(StatusCodes.Bad_InvalidArgument, "Cannot convert " + object + " to " + clazz2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new ServiceResultException(StatusCodes.Bad_InvalidArgument, "Cannot convert " + object + " to " + clazz2 + ": " + illegalArgumentException.getMessage());
        }
    }

    protected Object convertVariant(Variant variant, Class<?> clazz, Class<?> clazz2) throws ServiceResultException {
        return this.convertValue(variant.getValue(), clazz, clazz2);
    }

    protected Object numberToInteger(Number number, NodeId object) {
        if ((object = this.jd.findNode((NodeId)object)) != null && object instanceof UaDataType) {
            return this.numberToInteger(number, (UaDataType)object);
        }
        return null;
    }

    protected Object numberToInteger(Number number, UaDataType uaDataType) {
        Number number2 = null;
        if (uaDataType.getJavaClass().equals(Byte.class)) {
            number2 = number.byteValue();
        } else if (uaDataType.getJavaClass().equals(Short.class)) {
            number2 = number.shortValue();
        } else if (uaDataType.getJavaClass().equals(Integer.class)) {
            number2 = number.intValue();
        } else if (uaDataType.getJavaClass().equals(Long.class)) {
            number2 = number.longValue();
        }
        return number2;
    }

    protected Number toNumber(Object object, Class<?> clazz) throws ClassCastException {
        if (object instanceof Number) {
            object = (Number)object;
        } else if (object instanceof Boolean) {
            object = (Boolean)object != false ? 1 : 0;
        } else if (object instanceof String) {
            object = clazz.equals(Double.class) ? (Number)Double.parseDouble((String)object) : (Number)(clazz.equals(Float.class) ? (Number)Float.valueOf(Float.parseFloat((String)object)) : (Number)(clazz.equals(Long.class) || clazz.equals(UnsignedLong.class) || clazz.equals(UnsignedInteger.class) ? (Number)Long.parseLong((String)object) : (Number)Integer.parseInt((String)object)));
        } else {
            throw new ClassCastException("Cannot convert to Number: " + object);
        }
        return object;
    }
}

