/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua;

import java.util.ArrayList;
import java.util.List;
import org.opcfoundation.ua.builtintypes.ExtensionObject;
import org.opcfoundation.ua.builtintypes.Structure;
import org.opcfoundation.ua.core.ContentFilter;
import org.opcfoundation.ua.core.ContentFilterElement;
import org.opcfoundation.ua.core.FilterOperand;
import org.opcfoundation.ua.core.FilterOperator;
import org.opcfoundation.ua.encoding.EncoderContext;
import org.opcfoundation.ua.encoding.EncodingException;

public class ContentFilterBuilder {
    private final List<ContentFilterElement> elements = new ArrayList<ContentFilterElement>();
    private final EncoderContext bg;

    public static void checkOperandCount(FilterOperator filterOperator, int n2) {
        int n3;
        if (filterOperator == FilterOperator.InList) {
            if (n2 < 2) {
                throw new IllegalArgumentException("operand count for operator " + filterOperator + " must be at least 2; was " + n2);
            }
            return;
        }
        switch (filterOperator) {
            case IsNull: 
            case Not: 
            case InView: 
            case OfType: {
                n3 = 1;
                break;
            }
            case Between: {
                n3 = 3;
                break;
            }
            case RelatedTo: {
                n3 = 6;
                break;
            }
            default: {
                n3 = 2;
            }
        }
        if (n2 != n3) {
            throw new IllegalArgumentException("operand count for operator " + filterOperator + " must be " + n3 + "; was " + n2);
        }
    }

    public ContentFilterBuilder(EncoderContext encoderContext) {
        this.bg = encoderContext;
    }

    public void add(FilterOperator filterOperator, FilterOperand ... filterOperandArray) {
        ContentFilterBuilder.checkOperandCount(filterOperator, filterOperandArray.length);
        ExtensionObject[] extensionObjectArray = new ExtensionObject[filterOperandArray.length];
        for (int i2 = 0; i2 < filterOperandArray.length; ++i2) {
            try {
                extensionObjectArray[i2] = ExtensionObject.binaryEncode((Structure)filterOperandArray[i2], (EncoderContext)this.bg);
                continue;
            }
            catch (EncodingException encodingException) {
                throw new IllegalArgumentException(String.format("Invalid operand #%d", i2), encodingException);
            }
        }
        ContentFilterElement contentFilterElement = new ContentFilterElement(filterOperator, extensionObjectArray);
        this.elements.add(contentFilterElement);
    }

    public ContentFilter getContentFilter() {
        return new ContentFilter(this.elements.toArray(new ContentFilterElement[this.elements.size()]));
    }
}

