/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua;

import com.prosysopc.ua.SecureIdentity;
import com.prosysopc.ua.SecureIdentityException;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.security.GeneralSecurityException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import org.opcfoundation.ua.builtintypes.LocalizedText;
import org.opcfoundation.ua.core.ApplicationDescription;
import org.opcfoundation.ua.core.SignedSoftwareCertificate;
import org.opcfoundation.ua.transport.security.Cert;
import org.opcfoundation.ua.transport.security.KeyPair;
import org.opcfoundation.ua.transport.security.PrivKey;
import org.opcfoundation.ua.utils.CertificateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApplicationIdentity
extends SecureIdentity {
    public static final String CERT_FILE_EXTENSIONS = ".der";
    private static int dQ = 3650;
    private static Logger logger = LoggerFactory.getLogger(ApplicationIdentity.class);
    private static final String[] dR = new String[]{".pem", ".pfx", ".key"};
    private ApplicationDescription applicationDescription = new ApplicationDescription();
    private KeyPair[] dS;
    private KeyPair dT;
    private String dU;
    private final List<SignedSoftwareCertificate> softwareCertificates = new ArrayList<SignedSoftwareCertificate>();

    public static ApplicationIdentity createCertificate(ApplicationDescription applicationDescription, String object, KeyPair keyPair, String ... stringArray) throws SecureIdentityException {
        ApplicationIdentity.a(applicationDescription);
        object = ApplicationIdentity.createCertificate(applicationDescription.getApplicationName().getText(), (String)object, keyPair, applicationDescription.getApplicationUri(), stringArray);
        ((ApplicationIdentity)object).setApplicationDescription(applicationDescription);
        return object;
    }

    public static ApplicationIdentity createCertificate(ApplicationDescription applicationDescription, String string, String ... stringArray) throws SecureIdentityException {
        return ApplicationIdentity.createCertificate(applicationDescription, string, null, stringArray);
    }

    public static ApplicationIdentity createCertificate(String object, String string, KeyPair keyPair, String string2, String ... stringArray) throws SecureIdentityException {
        object = ApplicationIdentity.createKeyPair((String)object, string, dQ, keyPair, string2, stringArray);
        object = new ApplicationIdentity(object.getCertificate(), object.getPrivateKey());
        ((ApplicationIdentity)object).setOrganisation(string);
        return object;
    }

    public static KeyPair createHttpsCertificate(ApplicationDescription object, String string, KeyPair keyPair) throws GeneralSecurityException, IOException {
        object = object.getApplicationUri();
        object = CertificateUtils.createHttpsCertificate((String)string, (String)object, (int)3650, (KeyPair)keyPair);
        return object;
    }

    public static KeyPair createKeyPair(String string, String string2, int n2, KeyPair keyPair, String string3, String ... stringArray) throws SecureIdentityException {
        if (string3 != null && string3.contains("localhost")) {
            throw new IllegalArgumentException("ApplicationURI should not contain 'localhost'.");
        }
        try {
            string2 = CertificateUtils.createApplicationInstanceCertificate((String)string, (String)string2, (String)string3, (int)n2, (KeyPair)keyPair, (String[])stringArray);
            logger.info("Created a new Certificate: {}; ApplicationURI={} KeySize={}", new Object[]{string2.getCertificate().getCertificate().getSubjectX500Principal().toString(), string3, CertificateUtils.getKeySize()});
        }
        catch (Exception exception) {
            throw new SecureIdentityException("Cannot create certificate for application " + string, exception);
        }
        return string2;
    }

    public static String getActualHostName() {
        Object object;
        try {
            object = InetAddress.getLocalHost();
        }
        catch (UnknownHostException unknownHostException) {
            logger.warn("Cannot determine Hostname. Using 'localhost'");
            return "localhost";
        }
        String string = ((InetAddress)object).getHostName();
        logger.debug("hostName={}", (Object)string);
        boolean bl = string.toLowerCase().contains("localhost");
        String string2 = ((InetAddress)object).getHostAddress();
        logger.debug("ipAddress={}", (Object)string2);
        if (!bl && string.contains(".") && !string.equals(string2)) {
            object = string;
        } else {
            object = ((InetAddress)object).getCanonicalHostName();
            logger.debug("canonicalHostName={}", object);
            boolean bl2 = ((String)object).toLowerCase().contains("localhost");
            if (bl) {
                if (bl2) {
                    object = string2;
                }
            } else if (string.contains(".") || bl2 || ((String)object).equals(string2)) {
                object = string;
            }
        }
        logger.debug("bar3");
        return object;
    }

    public static int getDefaultCertificateDays() {
        return dQ;
    }

    public static ApplicationIdentity loadOrCreateCertificate(ApplicationDescription applicationDescription, String string, String string2, File file, boolean bl, String ... stringArray) throws SecureIdentityException, IOException {
        return ApplicationIdentity.loadOrCreateCertificate(applicationDescription, string, string2, file, null, null, bl, stringArray);
    }

    public static ApplicationIdentity loadOrCreateCertificate(ApplicationDescription applicationDescription, String object, String string, File file, KeyPair keyPair, int[] nArray, boolean bl, String ... stringArray) throws SecureIdentityException, IOException {
        ApplicationIdentity.a(applicationDescription);
        object = ApplicationIdentity.loadOrCreateCertificate(applicationDescription.getApplicationName().getText(), (String)object, string, file, keyPair, nArray, bl, applicationDescription.getApplicationUri(), stringArray);
        ((ApplicationIdentity)object).setApplicationDescription(applicationDescription);
        return object;
    }

    public static ApplicationIdentity loadOrCreateCertificate(String string, String string2, File file, File file2, String string3, KeyPair keyPair, boolean bl, String string4, String ... stringArray) throws SecureIdentityException, IOException {
        string = ApplicationIdentity.loadOrCreateKeyPair(string, string2, file, file2, string3, keyPair, bl, string4, stringArray);
        return new ApplicationIdentity(string.getCertificate(), string.getPrivateKey());
    }

    public static ApplicationIdentity loadOrCreateCertificate(String string, String string2, String string3, File file, KeyPair keyPair, int[] nArray, boolean bl, String string4, String ... stringArray) throws SecureIdentityException, IOException {
        if (nArray == null || nArray.length == 0) {
            nArray = new int[]{0};
        }
        KeyPair[] keyPairArray = new KeyPair[nArray.length];
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            int n2 = nArray[i2];
            Object object = string;
            if (n2 > 0) {
                object = (String)object + "_" + n2;
                CertificateUtils.setKeySize((int)n2);
            } else if (i2 > 0) {
                throw new IllegalArgumentException("KeySize 0 may only be defined as the first entry to loadOrCreateCertificate");
            }
            File file2 = ApplicationIdentity.getBestFile(file, (String)object, CERT_FILE_EXTENSIONS);
            object = ApplicationIdentity.getBestFile(file, (String)object, dR);
            keyPairArray[i2] = ApplicationIdentity.loadOrCreateKeyPair(string, string2, file2, (File)object, string3, keyPair, bl, string4, stringArray);
        }
        return new ApplicationIdentity(keyPairArray);
    }

    public static KeyPair loadOrCreateHttpsCertificate(ApplicationDescription applicationDescription, String string, String string2, KeyPair keyPair, File file, boolean bl) throws IOException, SecureIdentityException {
        boolean bl2;
        String string3 = applicationDescription.getApplicationName().getText();
        string3 = string3 + "_https";
        File file2 = ApplicationIdentity.getBestFile(file, string3, CERT_FILE_EXTENSIONS);
        KeyPair keyPair2 = ApplicationIdentity.loadCertificate("HTTPS", string2, bl, file2, file = ApplicationIdentity.getBestFile(file, string3, dR), bl2 = file.getName().toLowerCase().endsWith(".pfx"));
        if (keyPair2 == null) {
            try {
                keyPair2 = ApplicationIdentity.createHttpsCertificate(applicationDescription, string, keyPair);
            }
            catch (GeneralSecurityException generalSecurityException) {
                throw new SecureIdentityException("Failed to create HTTPS certificate.", generalSecurityException);
            }
            try {
                ApplicationIdentity.saveCertificate("HTTPS", keyPair2, file2, file, string2, bl2);
            }
            catch (GeneralSecurityException generalSecurityException) {
                throw new SecureIdentityException("Failed to save HTTPS certificate to PKCS12 store.", generalSecurityException);
            }
        }
        return keyPair2;
    }

    public static KeyPair loadOrCreateIssuerCertificate(String string, File file, String string2, int n2, boolean bl) throws IOException, SecureIdentityException {
        boolean bl2;
        File file2 = ApplicationIdentity.getBestFile(file, string, CERT_FILE_EXTENSIONS);
        KeyPair keyPair = ApplicationIdentity.loadCertificate("Issuer", string2, bl, file2, file = ApplicationIdentity.getBestFile(file, string, dR), bl2 = file.getName().toLowerCase().endsWith(".pfx"));
        if (keyPair == null) {
            try {
                keyPair = CertificateUtils.createIssuerCertificate((String)string, (int)n2, null);
            }
            catch (GeneralSecurityException generalSecurityException) {
                throw new SecureIdentityException("Failed to create Issuer certificate.", generalSecurityException);
            }
            try {
                ApplicationIdentity.saveCertificate("Issuer", keyPair, file2, file, string2, bl2);
            }
            catch (GeneralSecurityException generalSecurityException) {
                throw new SecureIdentityException("Failed to save Issuer certificate to PKCS12 store.", generalSecurityException);
            }
        }
        return keyPair;
    }

    /*
     * Unable to fully structure code
     */
    public static KeyPair loadOrCreateKeyPair(String var0, String var1_1, File var2_2, File var3_3, String var4_4, KeyPair var5_5, boolean var6_6, String var7_7, String ... var8_8) throws IOException, SecureIdentityException {
        var9_9 = false;
        var10_10 = false;
        var11_11 = null;
        var12_12 = null;
        if (var2_2.exists() && var3_3.exists()) {
            ApplicationIdentity.logger.info("Reading application certificate from {}", (Object)var2_2.getAbsolutePath());
            try {
                var11_11 = Cert.load((File)var2_2);
            }
            catch (CertificateException var13_13) {
                throw new SecureIdentityException("Cannot load certificate", var13_13);
            }
            if (var11_11 != null) {
                try {
                    var11_11.getCertificate().checkValidity();
                }
                catch (CertificateExpiredException var13_14) {
                    ApplicationIdentity.logger.info("Certificate expired.");
                    if (var6_6) {
                        var9_9 = true;
                    }
                    throw new SecureIdentityException("Certificate expired", var13_14);
                }
                catch (CertificateException var13_15) {
                    throw new SecureIdentityException("Certificate cannot be loaded from file " + var2_2, var13_15);
                }
            }
            ApplicationIdentity.logger.info("Reading private key from keystore {}", (Object)var3_3.getAbsolutePath());
            try {
                block30: {
                    try {
                        var12_12 = PrivKey.load((File)var3_3, (String)var4_4);
                        ApplicationIdentity.logger.debug("Read private key in PEM format");
                    }
                    catch (Exception var13_16) {
                        ApplicationIdentity.logger.debug("Failed to read PEM: " + var13_16.getMessage(), (Throwable)var13_16);
                        if (!var13_16.getMessage().contains("password")) break block30;
                        throw new SecureIdentityException("Private key cannot be loaded from file " + var3_3, var13_16);
                    }
                }
                if (var12_12 != null) ** GOTO lbl46
                var12_12 = PrivKey.loadFromKeyStore((File)var3_3, (String)var4_4);
                ApplicationIdentity.logger.debug("Read private key in PKCS12 format");
                var10_10 = true;
            }
            catch (IOException var13_18) {
                throw new SecureIdentityException("Private key cannot be loaded from file " + var3_3, var13_18);
            }
            catch (GeneralSecurityException var13_19) {
                throw new SecureIdentityException("Private key cannot be loaded from file " + var3_3, var13_19);
            }
        } else {
            ApplicationIdentity.logger.debug("Application certificate or private key not found");
            var9_9 = true;
        }
lbl46:
        // 3 sources

        if (var9_9) {
            ApplicationIdentity.logger.info("Creating a new application certificate & private key");
            ApplicationIdentity.b(var2_2);
            ApplicationIdentity.b(var3_3);
            if (var11_11 != null) {
                try {
                    var0 = CertificateUtils.renewApplicationInstanceCertificate((String)var0, (String)var1_1, (String)var7_7, (int)ApplicationIdentity.dQ, (KeyPair)new KeyPair(var11_11, var12_12), (KeyPair)var5_5, (String[])var8_8);
                }
                catch (GeneralSecurityException var13_20) {
                    throw new SecureIdentityException("Failed to renew the application instance certificate", var13_20);
                }
                catch (IllegalStateException var13_21) {
                    throw new SecureIdentityException("Failed to renew the application instance certificate", var13_21);
                }
            } else {
                var0 = ApplicationIdentity.createKeyPair(var0, var1_1, ApplicationIdentity.dQ, var5_5, var7_7, var8_8);
            }
            var11_11 = var0.getCertificate();
            var12_12 = var0.getPrivateKey();
            var11_11.save(var2_2);
            if (var10_10) {
                try {
                    var12_12.saveToKeyStore(var11_11, var3_3, var4_4, var4_4, "PKCS12");
                }
                catch (KeyStoreException var13_22) {
                    throw new SecureIdentityException("Cannot save the private key to file " + var3_3, var13_22);
                }
                catch (NoSuchProviderException var13_23) {
                    throw new SecureIdentityException("Cannot save the private key to file " + var3_3, var13_23);
                }
                catch (NoSuchAlgorithmException var13_24) {
                    throw new SecureIdentityException("Cannot save the private key to file " + var3_3, var13_24);
                }
                catch (CertificateException var13_25) {
                    throw new SecureIdentityException("Cannot save the private key to file " + var3_3, var13_25);
                }
            } else {
                var13_17 = System.getProperty("java.runtime.name").toLowerCase();
                if (var13_17.contains("android")) {
                    var12_12.save(var3_3);
                } else {
                    var12_12.save(var3_3, var4_4);
                }
            }
        } else {
            var0 = new KeyPair(var11_11, var12_12);
        }
        return var0;
    }

    public static void setDefaultCertificateDays(int n2) {
        dQ = n2;
    }

    private static void b(File file) {
        if (file.getParentFile() != null) {
            file.getParentFile().mkdirs();
        }
    }

    private static void a(ApplicationDescription applicationDescription) throws NullPointerException {
        if (applicationDescription == null) {
            throw new NullPointerException("Cannot set null to ApplicationDescription");
        }
        String string = ApplicationIdentity.replaceLocalhostWithActualHostname(applicationDescription.getApplicationUri());
        applicationDescription.setApplicationUri(string);
        string = ApplicationIdentity.replaceLocalhostWithActualHostname(applicationDescription.getApplicationName().getText());
        Locale locale = applicationDescription.getApplicationName().getLocale();
        applicationDescription.setApplicationName(new LocalizedText(string, locale));
    }

    protected static File getBestFile(File file, String string, String ... stringArray) {
        File file2 = new File(file, string + stringArray[0]);
        if (!file2.exists()) {
            for (int i2 = 1; i2 < stringArray.length; ++i2) {
                File file3 = new File(file, string + stringArray[i2]);
                if (!file3.exists()) continue;
                return file3;
            }
        }
        return file2;
    }

    protected static KeyPair loadCertificate(String string, String string2, boolean bl, File file, File file2, boolean bl2) throws SecureIdentityException {
        if (file.exists() && file2.exists()) {
            Cert cert;
            try {
                cert = Cert.load((File)file);
                logger.info("{} certificate loaded from {}", (Object)string, (Object)file);
            }
            catch (CertificateException certificateException) {
                throw new SecureIdentityException("Failed to load " + string + " certificate from " + file, certificateException);
            }
            catch (IOException iOException) {
                throw new SecureIdentityException("Failed to load " + string + " certificate from " + file, iOException);
            }
            boolean bl3 = false;
            try {
                cert.getCertificate().checkValidity();
                bl3 = true;
            }
            catch (CertificateExpiredException certificateExpiredException) {
                logger.info("{} certificate expired.", (Object)string);
                if (!bl) {
                    throw new SecureIdentityException(string + " certificate expired", certificateExpiredException);
                }
            }
            catch (CertificateException certificateException) {
                throw new SecureIdentityException("Failed to load " + string + " certificate from " + file, certificateException);
            }
            if (bl3) {
                PrivKey privKey;
                try {
                    if (bl2) {
                        logger.debug("Reading private key in PKCS12 format");
                        privKey = PrivKey.loadFromKeyStore((File)file2, (String)string2);
                    } else {
                        logger.debug("Reading private key in PEM format");
                        privKey = PrivKey.load((File)file2, (String)string2);
                    }
                    logger.info("{} private key loaded from {}", (Object)string, (Object)file2);
                }
                catch (GeneralSecurityException generalSecurityException) {
                    throw new SecureIdentityException("Failed to load " + string + " private key from " + file2, generalSecurityException);
                }
                catch (IOException iOException) {
                    throw new SecureIdentityException("Failed to load " + string + " private key from " + file2, iOException);
                }
                return new KeyPair(cert, privKey);
            }
        }
        return null;
    }

    protected static ApplicationIdentity loadOrCreateFromProtectedStore(ApplicationDescription applicationDescription, String string, String string2, String string3, String string4, KeyPair keyPair, String ... stringArray) throws IOException, SecureIdentityException {
        KeyPair keyPair2;
        String string5;
        ApplicationIdentity.a(applicationDescription);
        String string6 = string5 = applicationDescription.getApplicationName().getText();
        try {
            keyPair2 = CertificateUtils.loadKeyPairFromProtectedStore((String)string3, (String)string6, (String)string4, (String)string2);
        }
        catch (Exception exception) {
            keyPair2 = ApplicationIdentity.createKeyPair(string5, string, dQ, keyPair, applicationDescription.getApplicationUri(), stringArray);
            try {
                CertificateUtils.saveKeyPairToProtectedStore((KeyPair)keyPair2, (String)string3, (String)string6, (String)string4, (String)string2);
            }
            catch (KeyStoreException keyStoreException) {
                throw new SecureIdentityException("Cannot save key pair to key store " + string3, exception);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new SecureIdentityException("Cannot save key pair to key store " + string3, exception);
            }
            catch (CertificateException certificateException) {
                throw new SecureIdentityException("Cannot save key pair to key store " + string3, exception);
            }
        }
        ApplicationIdentity applicationIdentity = new ApplicationIdentity(keyPair2.getCertificate(), keyPair2.getPrivateKey());
        applicationIdentity.setApplicationDescription(applicationDescription);
        applicationIdentity.setOrganisation(string);
        return applicationIdentity;
    }

    protected static String replaceLocalhostWithActualHostname(String string) {
        String string2 = string;
        if (string != null && string.contains("localhost")) {
            string2 = ApplicationIdentity.getActualHostName();
            string2 = string.replaceAll("localhost", string2);
        }
        return string2;
    }

    protected static void saveCertificate(String string, KeyPair keyPair, File file, File file2, String string2, boolean bl) throws IOException, GeneralSecurityException {
        ApplicationIdentity.b(file);
        ApplicationIdentity.b(file2);
        keyPair.getCertificate().save(file);
        logger.info("{} certificate saved to {}", (Object)string, (Object)file);
        if (bl) {
            keyPair.getPrivateKey().saveToKeyStore(keyPair.getCertificate(), file2, string2, string2, "PKCS12");
        }
        keyPair.getPrivateKey().save(file2, string2);
        logger.info("{} private key saved to {}", (Object)string, (Object)file2);
    }

    public ApplicationIdentity() {
    }

    public ApplicationIdentity(Cert cert, PrivKey privKey) {
        super(cert, privKey);
    }

    public ApplicationIdentity(File file, File file2, String string) throws IOException, SecureIdentityException {
        super(file, file2, string);
    }

    public ApplicationIdentity(File file, String string, String string2, String string3, String string4) throws IOException, SecureIdentityException {
        super(file, string, string2, string3, string4);
    }

    public ApplicationIdentity(KeyPair ... keyPairArray) {
        super(keyPairArray != null && keyPairArray.length > 0 ? keyPairArray[0].getCertificate() : null, keyPairArray != null && keyPairArray.length > 0 ? keyPairArray[0].getPrivateKey() : null);
        this.dS = keyPairArray;
    }

    public ApplicationIdentity(URL uRL, URL uRL2, String string) throws IOException, SecureIdentityException {
        super(uRL, uRL2, string);
    }

    public void addSoftwareCertificates(SignedSoftwareCertificate[] signedSoftwareCertificateArray) {
        if (signedSoftwareCertificateArray != null) {
            this.softwareCertificates.addAll(Arrays.asList(signedSoftwareCertificateArray));
        }
    }

    @Override
    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        object = (ApplicationIdentity)object;
        return !(this.softwareCertificates == null ? ((ApplicationIdentity)object).softwareCertificates != null : !((Object)this.softwareCertificates).equals(((ApplicationIdentity)object).softwareCertificates));
    }

    public ApplicationDescription getApplicationDescription() {
        return this.applicationDescription;
    }

    public KeyPair[] getCertificates() {
        if (this.dS != null) {
            return this.dS;
        }
        return new KeyPair[]{new KeyPair(this.getCertificate(), this.getPrivateKey())};
    }

    public KeyPair getHttpsCertificate() {
        return this.dT;
    }

    public String getOrganisation() {
        return this.dU;
    }

    public SignedSoftwareCertificate[] getSoftwareCertificates() {
        return this.softwareCertificates.toArray(new SignedSoftwareCertificate[this.softwareCertificates.size()]);
    }

    @Override
    public int hashCode() {
        int n2 = super.hashCode();
        n2 = n2 * 31 + (this.softwareCertificates == null ? 0 : ((Object)this.softwareCertificates).hashCode());
        return n2;
    }

    public void setApplicationDescription(ApplicationDescription applicationDescription) {
        ApplicationIdentity.a(applicationDescription);
        this.applicationDescription = applicationDescription;
    }

    public void setHttpsCertificate(KeyPair keyPair) {
        this.dT = keyPair;
    }

    public void setOrganisation(String string) {
        this.dU = string;
    }
}

