/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jcommon.xml;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.Attributes;

public class Elements {
    private Elements() {
    }

    public static Iterable<Node> asIterable(NodeList nodeList) {
        return new IterableNodeList(nodeList);
    }

    public static Iterator<Node> asIterator(NodeList nodeList) {
        return new NodeListIterator(nodeList);
    }

    public static Iterator<Node> childrenAsIterator(Element e) {
        return Elements.asIterator(e.getChildNodes());
    }

    public static Iterable<Node> childrenAsIterable(Element e) {
        return Elements.asIterable(e.getChildNodes());
    }

    public static void removeBlankStrings(Element x) {
        Elements.removeBlankStrings(x, true);
    }

    public static void removeBlankStrings(Element element, boolean recursive) {
        if (element == null) {
            return;
        }
        Iterator<Node> it = Elements.childrenAsIterator(element);
        while (it.hasNext()) {
            Node child = it.next();
            if (child instanceof Text && ((Text)child).getTextContent().trim().length() <= 0) {
                it.remove();
            }
            if (!recursive || !(child instanceof Element)) continue;
            Elements.removeBlankStrings((Element)child, true);
        }
    }

    public static Element getAncestorByTagName(Node e, String tagName) {
        Node x = e;
        while (x.getParentNode() != null && !(x instanceof Element) || !tagName.equals(((Element)x).getTagName())) {
            x = x.getParentNode();
        }
        return (Element)x.getParentNode();
    }

    public static float getAttributeAsFloat(Element elem, String attrName, float defaultValue) {
        String value = elem.getAttribute(attrName);
        if (value != null) {
            try {
                return Float.parseFloat(value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    public static int getAttributeAsInt(Element elem, String attrName, int defaultValue) {
        String value = elem.getAttribute(attrName);
        if (value != null) {
            try {
                return Integer.parseInt(value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    public static float getAttributeAsFloat(Attributes attrs, String attrName, float defaultValue) {
        String value = attrs.getValue(attrName);
        if (value != null) {
            try {
                return Float.parseFloat(value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    public static int getAttributeAsInt(Attributes attrs, String attrName, int defaultValue) {
        String value = attrs.getValue(attrName);
        if (value != null) {
            try {
                return Integer.parseInt(value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    private static class IterableNodeList
    implements Iterable<Node> {
        private NodeList nodes;

        public IterableNodeList(NodeList nodes) {
            this.nodes = nodes;
        }

        @Override
        public Iterator<Node> iterator() {
            return new NodeListIterator(this.nodes);
        }
    }

    private static class NodeListIterator
    implements Iterator<Node> {
        private NodeList nodeList;
        private int index = 0;

        public NodeListIterator(NodeList nodeList) {
            this.nodeList = nodeList;
        }

        @Override
        public void remove() {
            Node oldNode = this.nodeList.item(this.index);
            oldNode.getParentNode().removeChild(oldNode);
        }

        @Override
        public boolean hasNext() {
            return this.index < this.nodeList.getLength();
        }

        @Override
        public Node next() {
            if (this.hasNext()) {
                return this.nodeList.item(this.index++);
            }
            throw new NoSuchElementException();
        }
    }
}

