/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jcommon.web;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import javax.servlet.ServletOutputStream;
import javax.servlet.WriteListener;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;

public class RedirectedHttpServletResponse
extends HttpServletResponseWrapper {
    private ServletOutputStream sout;
    private PrintWriter writer;

    public RedirectedHttpServletResponse(HttpServletResponse httpServletResponse, OutputStream out) {
        super(httpServletResponse);
        this.sout = new RedirectedServletOutputStream(out);
        this.writer = new PrintWriter(new OutputStreamWriter((OutputStream)this.sout));
    }

    public PrintWriter getWriter() throws IOException {
        return this.writer;
    }

    public ServletOutputStream getOutputStream() throws IOException {
        return this.sout;
    }

    public void flushBuffer() throws IOException {
        this.writer.flush();
        this.sout.flush();
    }

    private static class RedirectedServletOutputStream
    extends ServletOutputStream {
        private OutputStream out;

        public RedirectedServletOutputStream(OutputStream out) {
            this.out = out;
        }

        public void write(int b) throws IOException {
            this.out.write(b);
        }

        public void write(byte[] b, int off, int len) throws IOException {
            this.out.write(b, off, len);
        }

        public void flush() throws IOException {
            this.out.flush();
        }

        public void close() throws IOException {
            this.out.close();
        }

        public boolean isReady() {
            return true;
        }

        public void setWriteListener(WriteListener writeListener) {
        }
    }
}

