/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jcommon.web;

import com.lowagie.text.DocumentException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.jcommon.web.RedirectedHttpServletResponse;
import net.sf.jcommon.xml.Elements;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xhtmlrenderer.pdf.ITextRenderer;

public class Html2PdfConverter
implements Filter,
Servlet {
    private FilterConfig filterConfig;
    private ServletConfig servletConfig;

    public void init(FilterConfig filterConfig) throws ServletException {
        this.filterConfig = filterConfig;
    }

    public String getServletInfo() {
        return Html2PdfConverter.class.getName();
    }

    public ServletConfig getServletConfig() {
        return this.servletConfig;
    }

    public void init(ServletConfig config) throws ServletException {
        this.servletConfig = config;
    }

    private String getInitParameter(String name, String defaultValue) {
        String value = this.servletConfig != null ? this.servletConfig.getInitParameter(name) : this.filterConfig.getInitParameter(name);
        return value != null ? value : defaultValue;
    }

    public void service(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        if (!(request instanceof HttpServletRequest) || !(response instanceof HttpServletResponse)) {
            return;
        }
        this.convert((HttpServletRequest)request, (HttpServletResponse)response, null);
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (!(request instanceof HttpServletRequest) || !(response instanceof HttpServletResponse)) {
            return;
        }
        this.convert((HttpServletRequest)request, (HttpServletResponse)response, chain);
    }

    private void convert(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws ServletException, IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        RedirectedHttpServletResponse newResponse = new RedirectedHttpServletResponse(response, baos);
        if (chain != null) {
            chain.doFilter((ServletRequest)request, (ServletResponse)newResponse);
        } else {
            RequestDispatcher rd = request.getRequestDispatcher(request.getParameter(this.getInitParameter("uriParameter", "q")));
            rd.include((ServletRequest)request, (ServletResponse)newResponse);
        }
        newResponse.flushBuffer();
        ITextRenderer iTextRenderer = new ITextRenderer();
        iTextRenderer.setDocumentFromString(baos.toString(), request.getRequestURL().toString());
        String v = Html2PdfConverter.getMeta(iTextRenderer.getDocument(), "pdf.version");
        if (v != null) {
            iTextRenderer.setPDFVersion(v.charAt(0));
        }
        iTextRenderer.layout();
        try {
            baos = new ByteArrayOutputStream();
            iTextRenderer.createPDF((OutputStream)baos);
            response.setContentType("application/pdf");
            Html2PdfConverter.writeToResponse(response, baos);
            baos.close();
        }
        catch (DocumentException e) {
            throw new ServletException((Throwable)e);
        }
    }

    public void destroy() {
    }

    private static void writeToResponse(HttpServletResponse response, ByteArrayOutputStream baos) throws IOException {
        response.setContentLength(baos.size());
        ServletOutputStream out = response.getOutputStream();
        baos.writeTo((OutputStream)out);
        out.flush();
    }

    private static String getMeta(Document doc, String name) {
        for (Node x : Elements.asIterable(doc.getDocumentElement().getElementsByTagName("meta"))) {
            if (!(x instanceof Element) || !name.equals(((Element)x).getAttribute("name"))) continue;
            return ((Element)x).getAttribute("content");
        }
        return null;
    }
}

