/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jcommon.web;

import java.beans.FeatureDescriptor;
import java.util.Iterator;
import javax.el.ELContext;
import javax.el.ELResolver;

public class EnumELResolver
extends ELResolver {
    private String propertyName = "ENUMS";
    private String defaultPackage;

    public EnumELResolver() {
    }

    public EnumELResolver(String propertyName) {
        this.propertyName = propertyName;
    }

    public EnumELResolver(String propertyName, String defaultPackage) {
        this.propertyName = propertyName;
        this.defaultPackage = defaultPackage;
        if (defaultPackage != null && !defaultPackage.endsWith(".")) {
            this.defaultPackage = String.valueOf(this.defaultPackage) + ".";
        }
    }

    public Class<?> getCommonPropertyType(ELContext context, Object base) {
        return String.class;
    }

    public Iterator<FeatureDescriptor> getFeatureDescriptors(ELContext context, Object base) {
        return null;
    }

    public Class<?> getType(ELContext context, Object base, Object property) {
        Object v = this.getValue(context, base, property);
        return v != null ? v.getClass() : null;
    }

    public Object getValue(ELContext context, Object base, Object property) {
        if (!(property instanceof String)) {
            return false;
        }
        if (base == null && this.propertyName.equals(property)) {
            context.setPropertyResolved(true);
            return new EnumPath();
        }
        if (base instanceof EnumPath) {
            String path = ((EnumPath)base).path;
            path = String.valueOf(path == null ? "" : String.valueOf(path) + ".") + property.toString();
            ((EnumPath)base).path = path;
            Class<?> enumClass = null;
            try {
                enumClass = Class.forName(path);
            }
            catch (ClassNotFoundException e) {
                try {
                    enumClass = Class.forName(String.valueOf(this.defaultPackage) + path);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
            if (enumClass != null && enumClass.isEnum()) {
                context.setPropertyResolved(true);
                return enumClass.getEnumConstants();
            }
            context.setPropertyResolved(true);
            return base;
        }
        if (base instanceof Enum[]) {
            Enum[] enumArray = (Enum[])base;
            int n = enumArray.length;
            int n2 = 0;
            while (n2 < n) {
                Enum e = enumArray[n2];
                if (e.name().equals(property)) {
                    context.setPropertyResolved(true);
                    return e;
                }
                ++n2;
            }
        }
        return null;
    }

    public boolean isReadOnly(ELContext context, Object base, Object property) {
        return true;
    }

    public void setValue(ELContext context, Object base, Object property, Object value) {
        throw new UnsupportedOperationException("Enum values can only be read");
    }

    private static class EnumPath {
        private String path;

        private EnumPath() {
        }
    }
}

