/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jcommon.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;

public class XProperties
extends Properties {
    public static final String LIST_SEPARATOR = ";";
    private Properties defaults;
    private Map<String, List<String>> optionLists = new HashMap<String, List<String>>();

    public XProperties() {
    }

    public XProperties(Properties defaults) {
        super(defaults);
        this.defaults = defaults;
    }

    public boolean getBoolean(String name) {
        return this.getBoolean(name, false);
    }

    public boolean getBoolean(String name, boolean defaultValue) {
        Object val = this.get(name);
        if (val == null) {
            return defaultValue;
        }
        if (val instanceof Boolean) {
            return (Boolean)val;
        }
        return "true".equalsIgnoreCase(val.toString());
    }

    public int getInt(String name) {
        return this.getInt(name, 0);
    }

    public int getInt(String name, int defaultValue) {
        Object val = this.get(name);
        if (val == null) {
            return defaultValue;
        }
        if (val instanceof Number) {
            return ((Number)val).intValue();
        }
        try {
            return Integer.parseInt(val.toString());
        }
        catch (NumberFormatException exc) {
            return defaultValue;
        }
    }

    public double getDouble(String name) {
        return this.getDouble(name, 0.0);
    }

    public double getDouble(String name, double defaultValue) {
        Object val = this.get(name);
        if (val == null) {
            return defaultValue;
        }
        if (val instanceof Number) {
            return ((Number)val).doubleValue();
        }
        try {
            return Double.parseDouble(val.toString());
        }
        catch (NumberFormatException exc) {
            return defaultValue;
        }
    }

    public File getFile(String name) {
        return this.getFile(name, null);
    }

    public File getFile(String name, File defaultValue) {
        Object val = this.get(name);
        if (val == null) {
            return defaultValue;
        }
        if (val instanceof File) {
            return (File)val;
        }
        return new File(val.toString());
    }

    public List<String> getList(String name) {
        String s;
        List<String> v = this.optionLists.get(name);
        if (v == null && (s = this.getProperty(name)) != null) {
            v = new ArrayList<String>();
            StringTokenizer st = new StringTokenizer(s, LIST_SEPARATOR, false);
            while (st.hasMoreTokens()) {
                v.add(st.nextToken().trim());
            }
            this.optionLists.put(name, v);
        }
        return v;
    }

    @Override
    public Object get(Object key) {
        Object x = super.get(key);
        if (x == null && this.defaults != null) {
            x = this.defaults.get(key);
        }
        return x;
    }

    @Override
    public Object put(Object key, Object value) {
        this.optionLists.remove(key.toString());
        return super.put(key, value);
    }

    @Override
    public Object remove(Object key) {
        this.optionLists.remove(key.toString());
        return super.remove(key);
    }

    public void load(String filename) throws IOException {
        FileInputStream in = new FileInputStream(filename);
        super.load(in);
        ((InputStream)in).close();
    }

    public void load(File f) throws IOException {
        FileInputStream in = new FileInputStream(f);
        super.load(in);
        ((InputStream)in).close();
    }

    public void save(String filename) throws IOException {
        FileOutputStream out = new FileOutputStream(filename);
        this.save(out);
        ((OutputStream)out).close();
    }

    public void save(File f) throws IOException {
        File parent = f.getParentFile();
        if (!parent.exists() && !parent.mkdirs()) {
            throw new IOException("Parent directory cannot be created.");
        }
        FileOutputStream out = new FileOutputStream(f);
        this.save(out);
        ((OutputStream)out).close();
    }

    public void save(OutputStream out) {
        this.save(new OutputStreamWriter(out));
    }

    public void save(Writer writer) {
        PrintWriter pw = writer instanceof PrintWriter ? (PrintWriter)writer : new PrintWriter(writer);
        Enumeration<?> e = this.propertyNames();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            Object value = this.get(name);
            if (value == null) continue;
            pw.println(String.valueOf(name) + "=" + XProperties.escape(value.toString()));
        }
        pw.flush();
    }

    public static String escape(String value) {
        StringBuilder s = new StringBuilder();
        int i = 0;
        while (i < value.length()) {
            char ch = value.charAt(i);
            switch (ch) {
                case '\n': {
                    s.append("\\n");
                    break;
                }
                case '\\': {
                    s.append("\\\\");
                    break;
                }
                default: {
                    s.append(ch);
                }
            }
            ++i;
        }
        return s.toString();
    }

    public static XProperties load(Properties defaults, File f) throws IOException {
        XProperties p = new XProperties(defaults);
        p.load(f);
        return p;
    }
}

