/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jcommon.util;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;

public final class ReflectUtils {
    private ReflectUtils() {
    }

    public static int getTypeIndex(Class<?> clazz, String genericTypeName) {
        int i = 0;
        TypeVariable<Class<?>>[] typeVariableArray = clazz.getTypeParameters();
        int n = typeVariableArray.length;
        int n2 = 0;
        while (n2 < n) {
            TypeVariable<Class<?>> type = typeVariableArray[n2];
            if (type.getName().equals(genericTypeName)) {
                return i;
            }
            ++i;
            ++n2;
        }
        return -1;
    }

    public static Class<?> getClosestClass(Class<?> descendant, Class<?> ancestor) {
        while (descendant.getSuperclass() != ancestor && descendant != null) {
            descendant = descendant.getSuperclass();
        }
        return descendant;
    }

    public static Class<?> getActualType(Class<?> actualClass, Class<?> genericClass, String typeName) {
        Class<?> s = ReflectUtils.getClosestClass(actualClass, genericClass);
        if (s == null) {
            return null;
        }
        int idx = ReflectUtils.getTypeIndex(genericClass, typeName);
        if (idx < 0) {
            return null;
        }
        if (s.getGenericSuperclass() instanceof ParameterizedType) {
            Type actualType = ((ParameterizedType)s.getGenericSuperclass()).getActualTypeArguments()[idx];
            if (actualType instanceof Class) {
                return (Class)actualType;
            }
            if (actualType instanceof TypeVariable) {
                return ReflectUtils.getActualType(actualClass, s, ((TypeVariable)actualType).getName());
            }
        }
        return null;
    }
}

