/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jcommon.util;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;

public class RandomListIterator<T>
implements ListIterator<T> {
    private List<T> list;
    private List<Integer> history = new ArrayList<Integer>();
    private int current = -1;
    private boolean random;

    public RandomListIterator(List<T> list, boolean random) {
        this.list = list;
        this.random = random;
    }

    public RandomListIterator(List<T> list) {
        this(list, true);
    }

    public boolean isRandom() {
        return this.random;
    }

    public void setRandom(boolean random) {
        this.random = random;
    }

    @Override
    public boolean hasNext() {
        return this.random || this.current < 0 || this.history.get(this.current) + 1 < this.list.size();
    }

    @Override
    public T next() {
        if (!this.hasNext()) {
            return null;
        }
        ++this.current;
        int i = this.nextIndex();
        this.history.add(this.current, i);
        return this.list.get(i);
    }

    @Override
    public boolean hasPrevious() {
        return this.current > 0;
    }

    @Override
    public T previous() {
        if (!this.hasPrevious()) {
            return null;
        }
        --this.current;
        return this.list.get(this.history.get(this.current));
    }

    @Override
    public int nextIndex() {
        if (this.random) {
            return (int)(Math.random() * (double)this.list.size());
        }
        return this.current >= 0 ? this.history.get(this.current) + 1 : 0;
    }

    @Override
    public int previousIndex() {
        return this.current > 0 ? this.history.get(this.current - 1) : -1;
    }

    public void registerToHistory(T t) {
        int index = this.list.indexOf(t);
        if (index >= 0) {
            ++this.current;
            this.history.add(this.current, index);
        }
    }

    @Override
    public void remove() {
        if (this.current >= 0) {
            int index = this.history.get(this.current);
            this.list.remove(index);
            this.updateIndices(index, -1);
        }
    }

    @Override
    public void set(T t) {
        if (this.current >= 0) {
            int index = this.history.get(this.current);
            this.list.set(index, t);
        }
    }

    @Override
    public void add(T t) {
        if (this.current >= 0) {
            int index = this.history.get(this.current);
            this.list.add(index, t);
            this.updateIndices(index, 1);
        }
    }

    private void updateIndices(int overIndex, int delta) {
        ListIterator<Integer> i = this.history.listIterator();
        while (i.hasNext()) {
            int index = i.next();
            if (index < overIndex) continue;
            i.set(index + delta);
        }
    }
}

