/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jcommon.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Random;

public class Permutation {
    private static final Random RANDOM_GENERATOR = new Random();
    private int[] indices;

    protected Permutation(int[] indices) {
        this.indices = indices;
    }

    public int hashCode() {
        return Arrays.hashCode(this.indices);
    }

    public boolean equals(Object that) {
        return that instanceof Permutation && Arrays.equals(this.indices, ((Permutation)that).indices);
    }

    public String toString() {
        return Arrays.toString(this.indices);
    }

    public <T> List<T> permute(List<T> src) {
        return this.permute(src, new ArrayList());
    }

    public <T> List<T> permute(List<T> src, List<T> dest) {
        dest.clear();
        int i = 0;
        while (i < this.indices.length) {
            dest.add(src.get(this.indices[i]));
            ++i;
        }
        return dest;
    }

    public String permute(CharSequence src) {
        return this.permute(src, new StringBuilder()).toString();
    }

    public StringBuilder permute(CharSequence src, StringBuilder dest) {
        dest.setLength(0);
        int i = 0;
        while (i < this.indices.length) {
            dest.append(src.charAt(this.indices[i]));
            ++i;
        }
        return dest;
    }

    public <T> T[] permute(T[] src, T[] dest) {
        int i = 0;
        while (i < this.indices.length) {
            dest[i] = src[this.indices[i]];
            ++i;
        }
        return dest;
    }

    public byte[] permute(byte[] src) {
        return this.permute(src, new byte[src.length]);
    }

    public byte[] permute(byte[] src, byte[] dest) {
        int i = 0;
        while (i < this.indices.length) {
            dest[i] = src[this.indices[i]];
            ++i;
        }
        return dest;
    }

    public short[] permute(short[] src) {
        return this.permute(src, new short[src.length]);
    }

    public short[] permute(short[] src, short[] dest) {
        int i = 0;
        while (i < this.indices.length) {
            dest[i] = src[this.indices[i]];
            ++i;
        }
        return dest;
    }

    public int[] permute(int[] src) {
        return this.permute(src, new int[src.length]);
    }

    public int[] permute(int[] src, int[] dest) {
        int i = 0;
        while (i < this.indices.length) {
            dest[i] = src[this.indices[i]];
            ++i;
        }
        return dest;
    }

    public long[] permute(long[] src) {
        return this.permute(src, new long[src.length]);
    }

    public long[] permute(long[] src, long[] dest) {
        int i = 0;
        while (i < this.indices.length) {
            dest[i] = src[this.indices[i]];
            ++i;
        }
        return dest;
    }

    public boolean[] permute(boolean[] src) {
        return this.permute(src, new boolean[src.length]);
    }

    public boolean[] permute(boolean[] src, boolean[] dest) {
        int i = 0;
        while (i < this.indices.length) {
            dest[i] = src[this.indices[i]];
            ++i;
        }
        return dest;
    }

    public char[] permute(char[] src) {
        return this.permute(src, new char[src.length]);
    }

    public char[] permute(char[] src, char[] dest) {
        int i = 0;
        while (i < this.indices.length) {
            dest[i] = src[this.indices[i]];
            ++i;
        }
        return dest;
    }

    public float[] permute(float[] src) {
        return this.permute(src, new float[src.length]);
    }

    public float[] permute(float[] src, float[] dest) {
        int i = 0;
        while (i < this.indices.length) {
            dest[i] = src[this.indices[i]];
            ++i;
        }
        return dest;
    }

    public double[] permute(double[] src) {
        return this.permute(src, new double[src.length]);
    }

    public double[] permute(double[] src, double[] dest) {
        int i = 0;
        while (i < this.indices.length) {
            dest[i] = src[this.indices[i]];
            ++i;
        }
        return dest;
    }

    public static Permutation fromIndices(int[] indices) {
        return new Permutation(indices);
    }

    public static Permutation random(int n) {
        return Permutation.random(n, RANDOM_GENERATOR);
    }

    public static Permutation random(int n, Random randomGenerator) {
        int[] r = new int[n];
        int i = 0;
        while (i < r.length - 1) {
            r[i] = randomGenerator.nextInt(n - i - 1);
            ++i;
        }
        r[r.length - 1] = 0;
        return Permutation.fromRepresentation(r);
    }

    public static Iterator<Permutation> iterator(int n) {
        return new PermutationIterator(n);
    }

    public static Permutation getPermutation(int n, long k) {
        int[] r = new int[n];
        int i = 0;
        while (i < n - 1) {
            r[n - 2 - i] = (int)(k % (long)(i + 2));
            k /= (long)(i + 2);
            ++i;
        }
        r[n - 1] = 0;
        return Permutation.fromRepresentation(r);
    }

    public static Permutation fromRepresentation(int[] r) {
        int m = 0;
        int i = 0;
        while (i < r.length) {
            if (r[i] >= 0) {
                ++m;
            }
            ++i;
        }
        int[] indices = new int[m];
        int i2 = 0;
        while (i2 < indices.length) {
            indices[i2] = -1;
            ++i2;
        }
        i2 = 0;
        while (i2 < r.length) {
            if (r[i2] >= 0) {
                indices[Permutation.findAvailIndex((int[])indices, (int)r[i2])] = i2;
            }
            ++i2;
        }
        return Permutation.fromIndices(indices);
    }

    private static int findAvailIndex(int[] indices, int index) {
        int j = -1;
        int i = 0;
        while (i < indices.length) {
            if (indices[i] < 0) {
                ++j;
            }
            if (j == index) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private static class PermutationIterator
    implements Iterator<Permutation> {
        private int[] representation;

        public PermutationIterator(int n) {
            if (n <= 0) {
                throw new IllegalArgumentException("The permutation order must be bigger than 0");
            }
            this.representation = new int[n];
            this.representation[n - 1] = -1;
        }

        @Override
        public boolean hasNext() {
            return this.representation[this.representation.length - 1] <= 0;
        }

        @Override
        public Permutation next() {
            Permutation nextPerm = null;
            switch (this.representation[this.representation.length - 1]) {
                case -1: {
                    int j = 0;
                    while (j < this.representation.length) {
                        this.representation[j] = 0;
                        ++j;
                    }
                }
                case 0: {
                    int i;
                    nextPerm = Permutation.fromRepresentation(this.representation);
                    int n = i = 0;
                    this.representation[n] = this.representation[n] + 1;
                    while (this.representation[i] > this.representation.length - i - 1 && i < this.representation.length - 1) {
                        this.representation[i] = 0;
                        int n2 = ++i;
                        this.representation[n2] = this.representation[n2] + 1;
                    }
                    break;
                }
                default: {
                    nextPerm = null;
                }
            }
            return nextPerm;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Cannot remove a permutation");
        }
    }
}

