/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jcommon.util;

import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.regex.Pattern;

public class PatternGregorianCalendar
extends GregorianCalendar
implements Comparable<Calendar> {
    public static final int ANY = -1;
    private static final int maxFields = 10;
    private int[] ignoreFields = new int[10];
    private int ignoreFieldsCount = 0;
    private static Pattern patt1 = Pattern.compile("([0-9]{4}+|xxxx)/([0-9]{2}+|xx)/([0-9]{2}+|xx)\\s+([0-9]{2}+|xx):([0-9]{2}+|xx):([0-9]{2}+|xx)");
    private static Pattern patt2 = Pattern.compile("([0-9]{4}+|xxxx)/([0-9]{2}+|xx)/([0-9]{2}+|xx)([(]([1-7]|x)[)])\\s+([0-9]{2}+|xx):([0-9]{2}+|xx):([0-9]{2}+|xx)");

    public PatternGregorianCalendar() {
    }

    public PatternGregorianCalendar(int year, int month, int day, int hour, int minute, int second) {
        this(year, month, day, -1, hour, minute, second);
    }

    public PatternGregorianCalendar(int year, int month, int day, int weekday, int hour, int minute, int second) {
        this.set(1, year);
        this.set(2, month);
        this.set(5, day);
        this.set(7, weekday);
        this.set(11, hour);
        this.set(12, minute);
        this.set(13, second);
    }

    private boolean isIgnoreField(int field) {
        int i = 0;
        while (i < this.ignoreFieldsCount) {
            if (this.ignoreFields[i] == field) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private void addIgnoreField(int field) {
        if (!this.isIgnoreField(field)) {
            this.ignoreFields[this.ignoreFieldsCount++] = field;
        }
    }

    private void removeIgnoreField(int field) {
        int i = 0;
        while (i < this.ignoreFieldsCount) {
            if (this.ignoreFields[i] == field) {
                this.ignoreFields[i] = this.ignoreFields[--this.ignoreFieldsCount];
                break;
            }
            ++i;
        }
    }

    private int compareFieldTo(Calendar that, int field) {
        if (!(this.isIgnoreField(field) || that instanceof PatternGregorianCalendar && ((PatternGregorianCalendar)that).isIgnoreField(field))) {
            return this.get(field) - that.get(field);
        }
        return 0;
    }

    public int compareToCurrentDate() {
        return this.compareTo(new GregorianCalendar());
    }

    @Override
    public int compareTo(Date date) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        return this.compareTo(calendar);
    }

    @Override
    public int compareTo(Calendar that) {
        int retval = 0;
        retval = this.compareFieldTo(that, 1);
        retval = retval != 0 ? retval : this.compareFieldTo(that, 2);
        retval = retval != 0 ? retval : this.compareFieldTo(that, 5);
        retval = retval != 0 ? retval : this.compareFieldTo(that, 7);
        retval = retval != 0 ? retval : this.compareFieldTo(that, 11);
        retval = retval != 0 ? retval : this.compareFieldTo(that, 12);
        retval = retval != 0 ? retval : this.compareFieldTo(that, 13);
        return retval;
    }

    @Override
    public void set(int field, int value) {
        if (value == -1) {
            this.addIgnoreField(field);
        } else {
            this.removeIgnoreField(field);
            super.set(field, value);
        }
    }

    @Override
    public int get(int field) {
        if (this.isIgnoreField(field)) {
            return -1;
        }
        return super.get(field);
    }

    @Override
    public String toString() {
        StringBuffer s = new StringBuffer();
        if (!this.isIgnoreField(1)) {
            s.append(this.get(1));
        } else {
            s.append("xxxx");
        }
        s.append('/');
        if (!this.isIgnoreField(2)) {
            if (this.get(2) < 10) {
                s.append('0');
            }
            s.append(this.get(2));
        } else {
            s.append("xx");
        }
        s.append('/');
        if (!this.isIgnoreField(5)) {
            if (this.get(5) < 10) {
                s.append('0');
            }
            s.append(this.get(5));
        } else {
            s.append("xx");
        }
        if (!this.isIgnoreField(7)) {
            s.append('(');
            s.append(this.get(7));
            s.append(") ");
        } else {
            s.append(' ');
        }
        if (!this.isIgnoreField(11)) {
            if (this.get(11) < 10) {
                s.append('0');
            }
            s.append(this.get(11));
        } else {
            s.append("xx");
        }
        s.append(':');
        if (!this.isIgnoreField(12)) {
            if (this.get(12) < 10) {
                s.append('0');
            }
            s.append(this.get(12));
        } else {
            s.append("xx");
        }
        s.append(':');
        if (!this.isIgnoreField(13)) {
            if (this.get(13) < 10) {
                s.append('0');
            }
            s.append(this.get(13));
        } else {
            s.append("xx");
        }
        return s.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PatternGregorianCalendar parse(CharSequence s) {
        boolean form1 = false;
        boolean form2 = false;
        Pattern pattern = patt1;
        synchronized (pattern) {
            form1 = patt1.matcher(s).matches();
            if (!form1) {
                form2 = patt2.matcher(s).matches();
            }
        }
        if (form1) {
            int second;
            int minute;
            int hour;
            int day;
            int month;
            int year;
            try {
                year = Integer.parseInt(s.subSequence(0, 4).toString());
            }
            catch (NumberFormatException exc) {
                year = -1;
            }
            try {
                month = Integer.parseInt(s.subSequence(5, 7).toString());
            }
            catch (NumberFormatException exc) {
                month = -1;
            }
            try {
                day = Integer.parseInt(s.subSequence(8, 10).toString());
            }
            catch (NumberFormatException exc) {
                day = -1;
            }
            try {
                hour = Integer.parseInt(s.subSequence(11, 13).toString());
            }
            catch (NumberFormatException exc) {
                hour = -1;
            }
            try {
                minute = Integer.parseInt(s.subSequence(14, 16).toString());
            }
            catch (NumberFormatException exc) {
                minute = -1;
            }
            try {
                second = Integer.parseInt(s.subSequence(17, 19).toString());
            }
            catch (NumberFormatException exc) {
                second = -1;
            }
            return new PatternGregorianCalendar(year, month, day, hour, minute, second);
        }
        if (form2) {
            int second;
            int minute;
            int hour;
            int weekday;
            int day;
            int month;
            int year;
            try {
                year = Integer.parseInt(s.subSequence(0, 4).toString());
            }
            catch (NumberFormatException exc) {
                year = -1;
            }
            try {
                month = Integer.parseInt(s.subSequence(5, 7).toString());
            }
            catch (NumberFormatException exc) {
                month = -1;
            }
            try {
                day = Integer.parseInt(s.subSequence(8, 10).toString());
            }
            catch (NumberFormatException exc) {
                day = -1;
            }
            try {
                weekday = Integer.parseInt(s.subSequence(11, 13).toString());
            }
            catch (NumberFormatException exc) {
                weekday = -1;
            }
            try {
                hour = Integer.parseInt(s.subSequence(15, 17).toString());
            }
            catch (NumberFormatException exc) {
                hour = -1;
            }
            try {
                minute = Integer.parseInt(s.subSequence(18, 20).toString());
            }
            catch (NumberFormatException exc) {
                minute = -1;
            }
            try {
                second = Integer.parseInt(s.subSequence(21, 23).toString());
            }
            catch (NumberFormatException exc) {
                second = -1;
            }
            return new PatternGregorianCalendar(year, month, day, weekday, hour, minute, second);
        }
        return null;
    }
}

