/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jcommon.util;

import com.google.common.collect.ForwardingList;
import java.util.Collection;
import java.util.List;

public class CollectionUtils {
    private CollectionUtils() {
    }

    public static <T> List<T> maxSizeLimit(final List<T> decorated, final int maxSize, final boolean silent) {
        if (decorated.size() > maxSize) {
            throw new IllegalArgumentException("The list contains already more elements than " + maxSize);
        }
        return new ForwardingList<T>(){

            public boolean addAll(Collection<? extends T> collection) {
                return this.standardAddAll(collection);
            }

            public boolean addAll(int index, Collection<? extends T> elements) {
                return this.standardAddAll(index, elements);
            }

            public boolean add(T e) {
                if (!this.checkMaxSize()) {
                    return false;
                }
                return this.delegate().add(e);
            }

            public void add(int index, T e) {
                if (!this.checkMaxSize()) {
                    return;
                }
                this.delegate().add(index, e);
            }

            private boolean checkMaxSize() {
                if (this.size() >= maxSize) {
                    if (silent) {
                        return false;
                    }
                    throw new UnsupportedOperationException("Maximum Size " + maxSize + " reached");
                }
                return true;
            }

            protected List<T> delegate() {
                return decorated;
            }
        };
    }
}

