/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jcommon.util;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;

public class ClassLoaderHelper {
    private static FileFilter classFilter = new FileFilter(){

        @Override
        public boolean accept(File f) {
            return !f.isDirectory() && f.getName().endsWith(".class") && f.getName().indexOf(36) < 0;
        }
    };
    private static FileFilter dirFilter = new FileFilter(){

        @Override
        public boolean accept(File f) {
            return f.isDirectory();
        }
    };

    private ClassLoaderHelper() {
    }

    protected static void getClasses(File path, String pkg, Class<?> asg, boolean recursive, int level, Collection<String> result) {
        block8: {
            block7: {
                if (!path.isDirectory()) break block7;
                File[] childs = path.listFiles(classFilter);
                if (childs != null) {
                    File[] fileArray = childs;
                    int n = childs.length;
                    int n2 = 0;
                    while (n2 < n) {
                        File child = fileArray[n2];
                        result.add(String.valueOf(pkg) + (pkg.length() > 0 ? "." : "") + child.getName().substring(0, child.getName().lastIndexOf(".class")));
                        ++n2;
                    }
                }
                if (!recursive || (childs = path.listFiles(dirFilter)) == null) break block8;
                int i = 0;
                while (i < childs.length) {
                    ClassLoaderHelper.getClasses(childs[i], String.valueOf(pkg) + (pkg.length() > 0 ? "." : "") + childs[i].getName(), asg, recursive, level + 1, result);
                    ++i;
                }
                break block8;
            }
            if (!path.getName().endsWith(".jar") && !path.getName().endsWith(".zip")) break block8;
            try {
                Enumeration<? extends ZipEntry> e = new ZipFile(path).entries();
                while (e.hasMoreElements()) {
                    ZipEntry zent = e.nextElement();
                    if (zent.isDirectory() || !zent.getName().endsWith(".class") || zent.getName().indexOf(36) >= 0 || recursive && zent.getName().indexOf("/") < 0) continue;
                    result.add(zent.getName().substring(0, zent.getName().lastIndexOf(".class")).replace('/', '.'));
                }
            }
            catch (ZipException zipException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static String[] getClasses(File path, Class<?> asg, boolean recursive) {
        HashSet<String> x = new HashSet<String>();
        ClassLoaderHelper.getClasses(path, "", asg, recursive, 0, x);
        String[] r = new String[x.size()];
        int i = 0;
        for (Object e : x) {
            r[i++] = e.toString();
        }
        return r;
    }
}

