/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jcommon.ui.table;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import net.sf.jcommon.ui.UIUtils;
import net.sf.jcommon.ui.table.SearchableColumnsModel;

public class TableSearch
extends JPanel {
    private static final Icon DEFAULT_UPARROW_ICON;
    private static final Icon DEFAULT_DOWNARROW_ICON;
    public static final int UP = -1;
    public static final int DOWN = 1;
    private JTable table;
    private JComboBox columnsComboBox;
    private JPanel editorPanel;
    private TableCellEditor editor;
    private JButton downSearchButton;
    private JButton upSearchButton;

    static {
        URL url = TableSearch.class.getResource("searchup.gif");
        DEFAULT_UPARROW_ICON = url != null ? new ImageIcon(url) : null;
        url = TableSearch.class.getResource("searchdown.gif");
        DEFAULT_DOWNARROW_ICON = url != null ? new ImageIcon(url) : null;
    }

    public TableSearch(JTable table) {
        this.table = table;
        this.init();
    }

    private void init() {
        this.columnsComboBox = new JComboBox(new ColumnComboBoxModel(this.table.getColumnModel()));
        this.columnsComboBox.setFocusable(false);
        this.columnsComboBox.setEditable(false);
        this.columnsComboBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.columnsComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TableSearch.this.changeEditor(true);
            }
        });
        this.editorPanel = new JPanel(new BorderLayout());
        this.downSearchButton = new JButton();
        this.downSearchButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TableSearch.this.search(1);
            }
        });
        this.upSearchButton = new JButton();
        this.upSearchButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TableSearch.this.search(-1);
            }
        });
        JPanel buttonsPanel = new JPanel(new GridLayout(1, 2, 3, 0));
        buttonsPanel.add(this.downSearchButton);
        buttonsPanel.add(this.upSearchButton);
        this.setLayout(new BorderLayout(3, 0));
        this.add((Component)this.columnsComboBox, "West");
        this.add((Component)this.editorPanel, "Center");
        this.add((Component)buttonsPanel, "East");
        if (this.columnsComboBox.getItemCount() > 0) {
            this.columnsComboBox.setSelectedIndex(0);
        }
        this.table.getModel().addTableModelListener(new TableModelListener(){
            private boolean empty;
            {
                this.empty = TableSearch.this.table.getModel().getRowCount() <= 0;
            }

            @Override
            public void tableChanged(TableModelEvent e) {
                boolean x;
                boolean bl = x = TableSearch.this.table.getModel().getRowCount() <= 0;
                if (this.empty != x) {
                    this.empty = x;
                    TableSearch.this.changeEditor(false);
                }
            }
        });
        this.updateUI();
    }

    private void changeEditor(boolean focus) {
        int selectedIndex = this.columnsComboBox.getSelectedIndex();
        if (selectedIndex < 0 || this.table.getRowCount() <= 0) {
            this.editor = null;
            this.editorPanel.removeAll();
            this.editorPanel.repaint();
        } else {
            selectedIndex = ((ColumnComboBoxModel)this.columnsComboBox.getModel()).indexToColumnModelIndex(selectedIndex);
            this.editor = this.table.getColumnModel().getColumn(selectedIndex).getCellEditor();
            if (this.editor == null) {
                this.editor = this.table.getDefaultEditor(this.table.getColumnClass(selectedIndex));
            }
            Component c = this.editor.getTableCellEditorComponent(this.table, null, true, 0, selectedIndex);
            this.editorPanel.add(c);
            this.editorPanel.repaint();
            if (focus) {
                c.requestFocus();
            }
        }
    }

    public int search() {
        return this.search(1);
    }

    public int search(int direction) {
        if (this.editor != null) {
            this.editor.stopCellEditing();
            return this.search(this.columnsComboBox.getSelectedIndex(), this.editor.getCellEditorValue(), this.table.getSelectedRow() + direction, direction);
        }
        return -1;
    }

    public int search(int column, Object value, int from, int direction) {
        int begin;
        if (direction != -1 && direction != 1) {
            throw new IllegalArgumentException("Direction can be only UP or DOWN");
        }
        int n = begin = direction == 1 ? 0 : this.table.getRowCount() - 1;
        if (from < 0) {
            from = begin;
        }
        int to = direction == 1 ? this.table.getRowCount() : 0;
        int index = -1;
        int i = from;
        while (!(direction == 1 ? i >= to : i < to)) {
            Object x = this.table.getValueAt(i, column);
            if (x == null && value == null || x != null && x.equals(value)) {
                index = i;
                break;
            }
            i += direction;
        }
        if (index < 0 && from != begin) {
            index = this.search(column, value, begin, direction);
        }
        if (index >= 0) {
            this.table.setRowSelectionInterval(index, index);
        }
        return index;
    }

    @Override
    public void updateUI() {
        super.updateUI();
        if (this.downSearchButton != null) {
            this.downSearchButton.setIcon(UIUtils.getUIIcon("TableSearch.searchDownIcon", DEFAULT_DOWNARROW_ICON));
            this.downSearchButton.setText(UIUtils.getUIString("TableSearch.searchDownText", ""));
            this.downSearchButton.setToolTipText(UIUtils.getUIString("TableSearch.searchDownToolTipText", "Search Down"));
            this.upSearchButton.setIcon(UIUtils.getUIIcon("TableSearch.searchUpIcon", DEFAULT_UPARROW_ICON));
            this.upSearchButton.setText(UIUtils.getUIString("TableSearch.searchUpText", ""));
            this.upSearchButton.setToolTipText(UIUtils.getUIString("TableSearch.searchUpToolTipText", "Search Up"));
        }
    }

    private class ColumnComboBoxModel
    extends AbstractListModel
    implements ComboBoxModel {
        private TableColumnModel tableColumnModel;
        private List<TableColumn> columns = new ArrayList<TableColumn>();
        private Object selectedItem;

        public ColumnComboBoxModel(TableColumnModel tableColumnModel) {
            this.tableColumnModel = tableColumnModel;
            tableColumnModel.addColumnModelListener(new TableColumnModelListener(){

                @Override
                public void columnMarginChanged(ChangeEvent e) {
                }

                @Override
                public void columnSelectionChanged(ListSelectionEvent e) {
                }

                @Override
                public void columnAdded(TableColumnModelEvent e) {
                    ColumnComboBoxModel.this.update();
                }

                @Override
                public void columnMoved(TableColumnModelEvent e) {
                    ColumnComboBoxModel.this.update();
                }

                @Override
                public void columnRemoved(TableColumnModelEvent e) {
                    ColumnComboBoxModel.this.update();
                }
            });
            this.update();
        }

        protected boolean isColumnSearchable(int index) {
            if (TableSearch.this.table.getColumnModel() instanceof SearchableColumnsModel) {
                return ((SearchableColumnsModel)((Object)TableSearch.this.table.getColumnModel())).isColumnSearchable(index);
            }
            if (TableSearch.this.table.getModel() instanceof SearchableColumnsModel) {
                return ((SearchableColumnsModel)((Object)TableSearch.this.table.getModel())).isColumnSearchable(index);
            }
            return true;
        }

        private void update() {
            this.columns.clear();
            int i = 0;
            int n = this.tableColumnModel.getColumnCount();
            while (i < n) {
                TableColumn column = this.tableColumnModel.getColumn(i);
                if (this.isColumnSearchable(i)) {
                    this.columns.add(column);
                }
                ++i;
            }
            this.fireContentsChanged(this, 0, this.columns.size());
        }

        @Override
        public int getSize() {
            return this.columns.size();
        }

        public int indexToColumnModelIndex(int index) {
            return this.columns.get(index).getModelIndex();
        }

        @Override
        public Object getElementAt(int index) {
            return this.columns.get(index).getHeaderValue();
        }

        @Override
        public Object getSelectedItem() {
            return this.selectedItem;
        }

        @Override
        public void setSelectedItem(Object selectedItem) {
            this.selectedItem = selectedItem;
        }
    }
}

