/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jcommon.ui.table;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import net.sf.jcommon.ui.table.StyledTableModel;

public class StyledRenderer
implements TableCellRenderer {
    private TableCellRenderer renderer;

    public StyledRenderer() {
        this(new DefaultTableCellRenderer());
    }

    public StyledRenderer(TableCellRenderer renderer) {
        this.renderer = renderer;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        TableModel model;
        Component c = this.renderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        if (!isSelected && (model = table.getModel()) instanceof StyledTableModel) {
            Font font;
            Color fgColor;
            Color bgColor = ((StyledTableModel)((Object)model)).getBackgroundColorAt(row, column);
            if (bgColor != null) {
                c.setBackground(bgColor);
            }
            if ((fgColor = ((StyledTableModel)((Object)model)).getForegroundColorAt(row, column)) != null) {
                c.setForeground(fgColor);
            }
            if ((font = ((StyledTableModel)((Object)model)).getFontAt(row, column, c.getFont())) != null) {
                c.setFont(font);
            }
        }
        return c;
    }
}

