/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jcommon.ui.table;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.EventObject;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.EventListenerList;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;

public class FileCellRendererEditor
extends JPanel
implements TableCellRenderer,
TableCellEditor {
    private JTextField fileTextField;
    private JFileChooser fileChooser;
    private String dialogTitle = "Open";
    private int dialogType = 0;
    protected EventListenerList listenerList = new EventListenerList();
    protected transient ChangeEvent changeEvent = null;

    public FileCellRendererEditor() {
        this.init();
    }

    private void init() {
        this.fileTextField = new JTextField(30);
        JButton browseButton = new JButton("...");
        browseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FileCellRendererEditor.this.stopCellEditing();
                FileCellRendererEditor.this.browse();
            }
        });
        this.setLayout(new BorderLayout());
        this.add(this.fileTextField);
        this.add((Component)browseButton, "East");
    }

    private void browse() {
        int retval;
        File selectedFile;
        if (this.fileChooser == null) {
            this.fileChooser = new JFileChooser();
            this.fileChooser.setMultiSelectionEnabled(false);
            this.fileChooser.setAcceptAllFileFilterUsed(true);
            this.fileChooser.setDialogTitle(this.dialogTitle);
            this.fileChooser.setDialogType(this.dialogType);
            this.fileChooser.setFileSelectionMode(2);
        }
        if ((selectedFile = new File(this.fileTextField.getText())).exists()) {
            this.fileChooser.setCurrentDirectory(selectedFile.getParentFile());
            this.fileChooser.setSelectedFile(selectedFile);
        }
        if ((retval = this.dialogType == 0 ? this.fileChooser.showOpenDialog(this) : this.fileChooser.showSaveDialog(this)) == 0) {
            this.fileTextField.setText(this.fileChooser.getSelectedFile().getAbsolutePath());
        }
    }

    protected String getPath() {
        return this.fileTextField.getText();
    }

    protected void setPath(String path) {
        this.fileTextField.setText(path);
    }

    @Override
    public void requestFocus() {
        this.fileTextField.requestFocus();
    }

    @Override
    public Object getCellEditorValue() {
        return this.getPath();
    }

    public void setValue(Object value) {
        if (value instanceof String) {
            this.setPath(value.toString());
        } else if (value instanceof File) {
            this.setPath(((File)value).getAbsolutePath());
        }
    }

    @Override
    public boolean isCellEditable(EventObject anEvent) {
        return anEvent instanceof MouseEvent && ((MouseEvent)anEvent).getClickCount() >= 1;
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        table.getSelectionModel().setSelectionInterval(row, row);
        value = table.getModel().getValueAt(row, column);
        return this.getTableCellRendererComponent(table, value, true, true, row, column);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        this.setValue(value);
        return this;
    }

    @Override
    public boolean shouldSelectCell(EventObject anEvent) {
        return false;
    }

    @Override
    public boolean stopCellEditing() {
        this.fireEditingStopped();
        return true;
    }

    @Override
    public void cancelCellEditing() {
        this.fireEditingCanceled();
    }

    @Override
    public void addCellEditorListener(CellEditorListener l) {
        this.listenerList.add(CellEditorListener.class, l);
    }

    @Override
    public void removeCellEditorListener(CellEditorListener l) {
        this.listenerList.remove(CellEditorListener.class, l);
    }

    protected void fireEditingStopped() {
        Object[] listeners = this.listenerList.getListenerList();
        int i = listeners.length - 2;
        while (i >= 0) {
            if (listeners[i] == CellEditorListener.class) {
                if (this.changeEvent == null) {
                    this.changeEvent = new ChangeEvent(this);
                }
                ((CellEditorListener)listeners[i + 1]).editingStopped(this.changeEvent);
            }
            i -= 2;
        }
    }

    protected void fireEditingCanceled() {
        Object[] listeners = this.listenerList.getListenerList();
        int i = listeners.length - 2;
        while (i >= 0) {
            if (listeners[i] == CellEditorListener.class) {
                if (this.changeEvent == null) {
                    this.changeEvent = new ChangeEvent(this);
                }
                ((CellEditorListener)listeners[i + 1]).editingCanceled(this.changeEvent);
            }
            i -= 2;
        }
    }
}

