/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jcommon.ui.table;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import net.sf.jcommon.ui.PopupUtils;
import net.sf.jcommon.ui.table.DisplayedColumnsModel;
import net.sf.jcommon.ui.table.ToolTipColumnModel;

public class DisplayedColumnsMenu
extends JPopupMenu {
    private JTable table;
    private TableColumnModelListener columnModelListener;
    private MouseListener popupListener;

    public DisplayedColumnsMenu(JTable table) {
        this.table = table;
        this.init();
    }

    private void init() {
        this.addMenuItemsForColumns(0, this.table.getColumnCount() - 1);
        this.columnModelListener = new TableColumnModelListener(){

            @Override
            public void columnMarginChanged(ChangeEvent e) {
            }

            @Override
            public void columnSelectionChanged(ListSelectionEvent e) {
            }

            @Override
            public void columnAdded(TableColumnModelEvent e) {
                DisplayedColumnsMenu.this.addMenuItemsForColumns(e.getToIndex(), e.getToIndex());
            }

            @Override
            public void columnMoved(TableColumnModelEvent e) {
                DisplayedColumnsMenu.this.moveMenuItems(e.getFromIndex(), e.getToIndex());
            }

            @Override
            public void columnRemoved(TableColumnModelEvent e) {
                DisplayedColumnsMenu.this.removeMenuItemsForColumns(e.getFromIndex(), e.getFromIndex());
            }
        };
        this.table.getColumnModel().addColumnModelListener(this.columnModelListener);
        this.popupListener = new PopupUtils.ComponentPopupListener(this);
        this.table.getTableHeader().addMouseListener(this.popupListener);
        this.table.addPropertyChangeListener("tableHeader", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                ((JTableHeader)evt.getOldValue()).removeMouseListener(DisplayedColumnsMenu.this.popupListener);
                ((JTableHeader)evt.getNewValue()).addMouseListener(DisplayedColumnsMenu.this.popupListener);
            }
        });
    }

    private void addMenuItemsForColumns(int fromIndex, int toIndex) {
        int i = fromIndex;
        while (i <= toIndex) {
            this.add((Component)new JColumnMenuItem(this.table.getColumnModel().getColumn(i)), i);
            ++i;
        }
    }

    private void removeMenuItemsForColumns(int fromIndex, int toIndex) {
        int i = toIndex;
        while (i >= fromIndex) {
            ((JColumnMenuItem)this.getComponent(i)).uninstall();
            this.remove(i);
            ++i;
        }
    }

    private void moveMenuItems(int from, int to) {
        if (from != to) {
            JMenuItem x = (JMenuItem)this.getComponent(from);
            JMenuItem y = (JMenuItem)this.getComponent(to);
            this.remove(from);
            this.remove(to);
            this.add((Component)x, to);
            this.add((Component)y, from);
        }
    }

    protected boolean isColumnHideable(int index) {
        if (this.table.getColumnModel() instanceof DisplayedColumnsModel) {
            return ((DisplayedColumnsModel)((Object)this.table.getColumnModel())).isColumnHideable(index);
        }
        if (this.table.getModel() instanceof DisplayedColumnsModel) {
            return ((DisplayedColumnsModel)((Object)this.table.getModel())).isColumnHideable(index);
        }
        return true;
    }

    public void uninstall() {
        this.removeMenuItemsForColumns(0, this.getComponentCount() - 1);
        this.table.getColumnModel().removeColumnModelListener(this.columnModelListener);
        this.table.getTableHeader().removeMouseListener(this.popupListener);
    }

    public void setColumnVisible(int index, boolean visible) {
        ((JColumnMenuItem)this.getComponent(index)).setColumnVisible(visible);
    }

    public boolean isColumnVisible(int index) {
        return ((JColumnMenuItem)this.getComponent(index)).isColumnVisible();
    }

    private class JColumnMenuItem
    extends JCheckBoxMenuItem {
        private TableColumn column;
        private boolean visible = true;
        private int minWidth;
        private int maxWidth;
        private int preferredWidth;
        private boolean resizable;
        private PropertyChangeListener columnListener;

        public JColumnMenuItem(TableColumn column) {
            this.column = column;
            this.updateTextFromColumnHeaderValue();
            this.setSelected(true);
            this.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    boolean visible = JColumnMenuItem.this.isSelected();
                    boolean columnHiddeable = DisplayedColumnsMenu.this.isColumnHideable(JColumnMenuItem.this.column.getModelIndex());
                    if (visible || columnHiddeable) {
                        JColumnMenuItem.this.setColumnVisible(visible);
                    }
                    JColumnMenuItem.this.setEnabled(columnHiddeable);
                }
            });
            this.columnListener = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if ("headerValue".equals(evt.getPropertyName())) {
                        JColumnMenuItem.this.updateTextFromColumnHeaderValue();
                    }
                }
            };
            column.addPropertyChangeListener(this.columnListener);
            this.setEnabled(DisplayedColumnsMenu.this.isColumnHideable(column.getModelIndex()));
        }

        private void updateTextFromColumnHeaderValue() {
            Object value = this.column.getHeaderValue();
            String text = null;
            if (value != null) {
                text = value.toString();
            }
            if (text == null || text.length() <= 0) {
                text = "Column " + (DisplayedColumnsMenu.this.table.convertColumnIndexToView(this.column.getModelIndex()) + 1);
            }
            String tooltip = null;
            if (DisplayedColumnsMenu.this.table.getColumnModel() instanceof ToolTipColumnModel) {
                int index = DisplayedColumnsMenu.this.table.convertColumnIndexToView(this.column.getModelIndex());
                tooltip = ((ToolTipColumnModel)((Object)DisplayedColumnsMenu.this.table.getColumnModel())).getColumnTooltip(index);
            } else if (DisplayedColumnsMenu.this.table.getModel() instanceof ToolTipColumnModel) {
                int index = DisplayedColumnsMenu.this.table.convertColumnIndexToView(this.column.getModelIndex());
                tooltip = ((ToolTipColumnModel)((Object)DisplayedColumnsMenu.this.table.getModel())).getColumnTooltip(index);
            }
            if (tooltip != null) {
                text = String.valueOf(text) + " [" + tooltip + "]";
            }
            this.setText(text);
        }

        private void setColumnVisible(boolean visible) {
            if (this.visible == visible) {
                return;
            }
            this.visible = visible;
            if (visible) {
                this.column.setMinWidth(this.minWidth);
                this.column.setMaxWidth(this.maxWidth);
                this.column.setPreferredWidth(this.preferredWidth);
                this.column.setResizable(this.resizable);
            } else {
                this.minWidth = this.column.getMinWidth();
                this.maxWidth = this.column.getMaxWidth();
                this.preferredWidth = this.column.getPreferredWidth();
                this.resizable = this.column.getResizable();
                this.column.setMinWidth(0);
                this.column.setMaxWidth(0);
                this.column.setPreferredWidth(0);
                this.column.setResizable(false);
            }
        }

        private boolean isColumnVisible() {
            return this.visible;
        }

        private void uninstall() {
            this.column.removePropertyChangeListener(this.columnListener);
        }
    }
}

