/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jcommon.ui.table;

import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JTable;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.EventListenerList;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;

public class ButtonCellRendererEditor
extends JButton
implements TableCellRenderer,
TableCellEditor {
    protected EventListenerList listenerList = new EventListenerList();
    protected transient ChangeEvent changeEvent = null;
    protected JButton button;
    private boolean alwaysEnabled = true;
    private boolean textHidden = true;

    public ButtonCellRendererEditor() {
        this(null, null);
    }

    public ButtonCellRendererEditor(Icon icon) {
        this(null, icon);
    }

    public ButtonCellRendererEditor(String text) {
        this(text, null);
    }

    public ButtonCellRendererEditor(Action a) {
        this();
        this.setAction(a);
    }

    public ButtonCellRendererEditor(String text, Icon icon) {
        this.button = this;
        this.button.setFont(new Font("monospaced", 1, 18));
        this.button.setFocusable(false);
        this.button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ButtonCellRendererEditor.this.stopCellEditing();
            }
        });
        this.init(text, icon);
    }

    public ButtonCellRendererEditor(JButton button) {
        this.button = button;
        button.setFont(new Font("monospaced", 1, 18));
        button.setFocusable(false);
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ButtonCellRendererEditor.this.stopCellEditing();
            }
        });
    }

    @Override
    public Object getCellEditorValue() {
        return this;
    }

    public void setValue(Object value) {
        if (value instanceof Action) {
            this.button.setAction((Action)value);
            if (this.textHidden) {
                this.button.setText("");
            }
        } else if (value instanceof Icon) {
            this.button.setText("");
            this.button.setIcon((Icon)value);
        } else if (value instanceof String) {
            this.button.setText(value.toString());
            this.button.setIcon(null);
        }
        if (this.alwaysEnabled) {
            this.button.setEnabled(true);
        }
    }

    @Override
    public boolean isCellEditable(EventObject anEvent) {
        if (anEvent instanceof MouseEvent) {
            return ((MouseEvent)anEvent).getClickCount() >= 1;
        }
        return false;
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        table.getSelectionModel().setSelectionInterval(row, row);
        value = table.getModel().getValueAt(row, column);
        return this.getTableCellRendererComponent(table, value, true, true, row, column);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        this.setValue(value);
        return this.button;
    }

    public boolean isAlwaysEnabled() {
        return this.alwaysEnabled;
    }

    public void setAlwaysEnabled(boolean alwaysEnabled) {
        this.alwaysEnabled = alwaysEnabled;
    }

    public boolean isTextHidden() {
        return this.textHidden;
    }

    public void setTextHidden(boolean textHidden) {
        this.textHidden = textHidden;
    }

    @Override
    public boolean shouldSelectCell(EventObject anEvent) {
        return false;
    }

    @Override
    public boolean stopCellEditing() {
        this.fireEditingStopped();
        return true;
    }

    @Override
    public void cancelCellEditing() {
        this.fireEditingCanceled();
    }

    @Override
    public void addCellEditorListener(CellEditorListener l) {
        this.listenerList.add(CellEditorListener.class, l);
    }

    @Override
    public void removeCellEditorListener(CellEditorListener l) {
        this.listenerList.remove(CellEditorListener.class, l);
    }

    protected void fireEditingStopped() {
        Object[] listeners = this.listenerList.getListenerList();
        int i = listeners.length - 2;
        while (i >= 0) {
            if (listeners[i] == CellEditorListener.class) {
                if (this.changeEvent == null) {
                    this.changeEvent = new ChangeEvent(this);
                }
                ((CellEditorListener)listeners[i + 1]).editingStopped(this.changeEvent);
            }
            i -= 2;
        }
    }

    protected void fireEditingCanceled() {
        Object[] listeners = this.listenerList.getListenerList();
        int i = listeners.length - 2;
        while (i >= 0) {
            if (listeners[i] == CellEditorListener.class) {
                if (this.changeEvent == null) {
                    this.changeEvent = new ChangeEvent(this);
                }
                ((CellEditorListener)listeners[i + 1]).editingCanceled(this.changeEvent);
            }
            i -= 2;
        }
    }
}

