/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jcommon.ui;

import java.util.HashMap;
import java.util.Map;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import net.sf.jcommon.util.XProperties;

public class XPropertiesTable
extends JTable {
    private Map<String, TableCellRenderer> renderers = new HashMap<String, TableCellRenderer>();
    private Map<String, TableCellEditor> editors = new HashMap<String, TableCellEditor>();

    public XPropertiesTable() {
        super(new XPropertiesTableModel());
    }

    public void setPropertyRenderer(String propertyName, TableCellRenderer renderer) {
        this.renderers.put(propertyName, renderer);
    }

    public void setPropertyEditor(String propertyName, TableCellEditor editor) {
        this.editors.put(propertyName, editor);
    }

    public XPropertiesTableModel getPropertiesTableModel() {
        return (XPropertiesTableModel)this.getModel();
    }

    @Override
    public void setModel(TableModel dataModel) {
        if (!(dataModel instanceof XPropertiesTableModel)) {
            throw new IllegalArgumentException("Only XPropertiesTableModel is supported");
        }
        super.setModel(dataModel);
    }

    @Override
    public TableCellRenderer getCellRenderer(int row, int column) {
        TableCellRenderer renderer = null;
        if (column == 1) {
            renderer = this.renderers.get(this.getValueAt(row, 0).toString());
        }
        return renderer != null ? renderer : super.getCellRenderer(row, column);
    }

    @Override
    public TableCellEditor getCellEditor(int row, int column) {
        TableCellEditor editor = null;
        if (column == 1) {
            editor = this.editors.get(this.getValueAt(row, 0).toString());
        }
        return editor != null ? editor : super.getCellEditor(row, column);
    }

    public static class XPropertiesTableModel
    extends AbstractTableModel {
        private static final int NAME_COLUMN = 0;
        private static final int VALUE_COLUMN = 1;
        private XProperties properties;

        public XPropertiesTableModel() {
            this(new XProperties());
        }

        public XPropertiesTableModel(XProperties properties) {
            this.properties = properties;
        }

        public XProperties getProperties() {
            return this.properties;
        }

        public void setProperties(XProperties properties) {
            this.properties = properties;
            this.fireTableDataChanged();
        }

        private String getPropertyAt(int index) {
            return this.properties.keySet().toArray()[index].toString();
        }

        @Override
        public int getRowCount() {
            return this.properties.size();
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return this.getPropertyAt(rowIndex);
                }
                case 1: {
                    return this.properties.getProperty(this.getPropertyAt(rowIndex));
                }
            }
            return null;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 1;
        }

        @Override
        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return "Name";
                }
                case 1: {
                    return "Value";
                }
            }
            return "";
        }
    }
}

