/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jcommon.ui;

import java.awt.Color;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class UIUtils {
    private UIUtils() {
    }

    public static Color modifyByFactor(Color color, double factor) {
        int r = (int)((double)color.getRed() * factor);
        int g = (int)((double)color.getGreen() * factor);
        int b = (int)((double)color.getBlue() * factor);
        if (r < 0) {
            r = 0;
        }
        if (r > 255) {
            r = 255;
        }
        if (g < 0) {
            g = 0;
        }
        if (g > 255) {
            g = 255;
        }
        if (b < 0) {
            b = 0;
        }
        if (b > 255) {
            b = 255;
        }
        return new Color(r, g, b);
    }

    public static ImageIcon loadImageIcon(File imageFile) {
        if (imageFile == null) {
            return null;
        }
        return new ImageIcon(imageFile.getPath());
    }

    public static ImageIcon loadImageIcon(File imageFile, int maxWidth, int maxHeight) {
        Image image = UIUtils.loadImage(imageFile, maxWidth, maxHeight, 2);
        return image == null ? null : new ImageIcon(image);
    }

    public static ImageIcon loadImageIcon(InputStream input) {
        Image image = UIUtils.loadImage(input);
        return image == null ? null : new ImageIcon(image);
    }

    public static ImageIcon loadImageIcon(InputStream input, int maxWidth, int maxHeight) {
        Image image = UIUtils.loadImage(input, maxWidth, maxHeight, 2);
        return image == null ? null : new ImageIcon(image);
    }

    public static Image loadImage(File imageFile, int maxWidth, int maxHeight, int scaleType) {
        if (imageFile == null) {
            return null;
        }
        try {
            return UIUtils.loadImage(new BufferedInputStream(new FileInputStream(imageFile)), maxWidth, maxHeight, scaleType);
        }
        catch (FileNotFoundException e) {
            return null;
        }
    }

    private static double getScaleFactor(double actualWidth, double actualHeight, double maxWidth, double maxHeight) {
        double factor = 1.0;
        if (maxWidth > 0.0 && maxHeight > 0.0) {
            factor = Math.min(actualWidth / maxWidth, actualHeight / maxHeight);
        } else if (maxWidth > 0.0) {
            factor = actualWidth / maxWidth;
        } else if (maxHeight > 0.0) {
            factor = actualHeight / maxHeight;
        }
        return factor;
    }

    public static Image loadImage(InputStream input) {
        return UIUtils.loadImage(input, -1, -1, 2);
    }

    public static Image loadImage(InputStream input, int maxWidth, int maxHeight, int scaleType) {
        Image image = null;
        try {
            ImageInputStream imageInput = ImageIO.createImageInputStream(input);
            ImageReader reader = ImageIO.getImageReaders(imageInput).next();
            reader.setInput(imageInput, true, true);
            int imageIndex = 0;
            int scaleFactor = (int)UIUtils.getScaleFactor(reader.getWidth(imageIndex), reader.getHeight(imageIndex), maxWidth, maxHeight);
            if (scaleFactor > 1) {
                if (reader.hasThumbnails(imageIndex)) {
                    int thumbnailCount = reader.getNumThumbnails(imageIndex);
                    int thumbnailIndex = -1;
                    int thumbnailDiffWidth = 0;
                    int thumbnailDiffHeight = 0;
                    int i = 0;
                    while (i < thumbnailCount) {
                        int tw = reader.getThumbnailWidth(imageIndex, i);
                        int th = reader.getThumbnailHeight(imageIndex, i);
                        if (tw - maxWidth <= thumbnailDiffWidth && th - maxHeight <= thumbnailDiffHeight) {
                            thumbnailIndex = i;
                            thumbnailDiffWidth = tw - maxWidth;
                            thumbnailDiffHeight = th - maxHeight;
                        }
                        ++i;
                    }
                    if (thumbnailIndex >= 0) {
                        image = reader.readThumbnail(imageIndex, thumbnailIndex);
                    }
                }
                if (image == null) {
                    if (scaleType == 2) {
                        ImageReadParam readParam = reader.getDefaultReadParam();
                        readParam.setSourceSubsampling(scaleFactor, scaleFactor, 0, 0);
                        image = reader.read(imageIndex, readParam);
                    } else {
                        image = reader.read(imageIndex);
                        image = image.getScaledInstance(maxWidth * scaleFactor, maxHeight * scaleFactor, scaleType);
                    }
                }
            } else {
                image = reader.read(imageIndex);
            }
        }
        catch (IOException e) {
            image = null;
        }
        return image;
    }

    public static Image scaleImage(Image image, int maxWidth, int maxHeight, boolean keepAspectRatio) {
        return UIUtils.scaleImage(image, maxWidth, maxHeight, keepAspectRatio, 1);
    }

    public static Image scaleImage(Image image, int maxWidth, int maxHeight, boolean keepAspectRatio, int hints) {
        if (!keepAspectRatio) {
            return image.getScaledInstance(maxWidth, maxHeight, hints);
        }
        double scaleFactorWidth = image.getWidth(null) / maxWidth;
        double scaleFactorHeight = image.getHeight(null) / maxHeight;
        if (scaleFactorWidth != 1.0 || scaleFactorHeight != 1.0) {
            image = scaleFactorWidth > scaleFactorHeight ? image.getScaledInstance(maxWidth, -1, hints) : image.getScaledInstance(-1, maxHeight, hints);
        }
        return image;
    }

    public static ImageIcon scaleImageIcon(ImageIcon image, int maxWidth, int maxHeight, boolean keepAspectRatio) {
        return UIUtils.scaleImageIcon(image, maxWidth, maxHeight, keepAspectRatio, 1);
    }

    public static ImageIcon scaleImageIcon(ImageIcon image, int maxWidth, int maxHeight, boolean keepAspectRatio, int hints) {
        return new ImageIcon(UIUtils.scaleImage(image.getImage(), maxWidth, maxHeight, keepAspectRatio, hints));
    }

    public static BufferedImage convertImageToBufferedImage(Image image) {
        ImageObserver observer = null;
        BufferedImage bufferedImage = new BufferedImage(image.getWidth(observer), image.getHeight(observer), 4);
        bufferedImage.createGraphics().drawImage(image, 0, 0, observer);
        return bufferedImage;
    }

    public static void ensureVisible(JDialog dialog) {
        UIUtils.ensureVisible(dialog, true);
    }

    public static void ensureVisible(JDialog dialog, boolean center) {
        if (dialog.isVisible()) {
            dialog.repaint();
            dialog.requestFocus();
        } else {
            if (center) {
                dialog.setLocationRelativeTo(dialog.getParent());
            }
            dialog.setVisible(true);
        }
    }

    public static String getUIString(String key, String defaultValue) {
        String value = UIManager.getString(key);
        return value != null ? value : defaultValue;
    }

    public static Icon getUIIcon(String key, Icon defaultValue) {
        Icon value = UIManager.getIcon(key);
        return value != null ? value : defaultValue;
    }

    public static void installHeaderRenderer(JTable table, final TableCellRenderer renderer) {
        Enumeration<TableColumn> e = table.getColumnModel().getColumns();
        while (e.hasMoreElements()) {
            e.nextElement().setHeaderRenderer(renderer);
        }
        table.getColumnModel().addColumnModelListener(new TableColumnModelListener(){

            @Override
            public void columnMarginChanged(ChangeEvent e) {
            }

            @Override
            public void columnSelectionChanged(ListSelectionEvent e) {
            }

            @Override
            public void columnAdded(TableColumnModelEvent e) {
                int end = e.getToIndex();
                JTable table = (JTable)e.getSource();
                int i = e.getFromIndex();
                while (i < end) {
                    table.getColumn(table.getColumnName(i)).setHeaderRenderer(renderer);
                    ++i;
                }
            }

            @Override
            public void columnMoved(TableColumnModelEvent e) {
            }

            @Override
            public void columnRemoved(TableColumnModelEvent e) {
            }
        });
    }
}

