/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jcommon.ui;

import java.awt.AWTException;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.Toolkit;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import javax.swing.JWindow;

public class TransparentWindow
extends JWindow
implements MouseMotionListener,
FocusListener {
    Graphics tempImgGraphics;
    Image backgroundImage;
    Image temporaryImage;
    Point mousePointer;

    public TransparentWindow() {
        this.init();
        this.setVisible(true);
    }

    private void init() {
        this.addMouseMotionListener(this);
        this.capture();
        this.addFocusListener(this);
    }

    @Override
    public void focusGained(FocusEvent aFocusEvent) {
        Point aPoint = this.getLocation();
        this.setLocation(15000, 0);
        this.capture();
        this.setLocation(aPoint);
    }

    @Override
    public void focusLost(FocusEvent aFocusEvent) {
    }

    public void capture() {
        Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
        try {
            Robot aRobot = new Robot();
            Rectangle rect = new Rectangle(0, 0, dim.width, dim.height);
            this.backgroundImage = aRobot.createScreenCapture(rect);
        }
        catch (AWTException awte) {
            System.out.println("robot excepton occurred");
        }
    }

    @Override
    public void mouseDragged(MouseEvent aMouseEvent) {
        Point aPoint = aMouseEvent.getPoint();
        int x = this.getX() + aPoint.x - this.mousePointer.x;
        int y = this.getY() + aPoint.y - this.mousePointer.y;
        this.setLocation(x, y);
        Graphics graphics = this.getGraphics();
        this.paint(graphics);
    }

    @Override
    public void mouseMoved(MouseEvent aMouseEvent) {
        this.mousePointer = aMouseEvent.getPoint();
    }

    @Override
    public void paint(Graphics graphics) {
        graphics.drawImage(this.backgroundImage, 0, 0, this.getWidth(), this.getHeight(), this.getX(), this.getY(), this.getX() + this.getWidth(), this.getY() + this.getHeight(), null);
        super.paintComponents(graphics);
    }
}

