/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jcommon.ui;

import java.awt.AWTException;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.Window;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.awt.image.RescaleOp;
import javax.swing.Icon;
import javax.swing.SwingUtilities;

public class ScreenShotIcon
implements Icon {
    private float filterFactor = -0.5f;
    private BufferedImage sshot;

    public ScreenShotIcon(Component cloneComponent) {
        Window w = (Window)SwingUtilities.getAncestorOfClass(Window.class, cloneComponent);
        w.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseDragged(MouseEvent e) {
                ScreenShotIcon.this.capture(e.getComponent());
                e.getComponent().repaint();
            }

            @Override
            public void mouseMoved(MouseEvent e) {
            }
        });
    }

    private void capture(Component c) {
        try {
            Robot robot = new Robot();
            Point p = c.getLocationOnScreen();
            Window w = (Window)SwingUtilities.getAncestorOfClass(Window.class, c);
            Point location = w.getLocation();
            w.setLocation(15000, 0);
            this.sshot = robot.createScreenCapture(new Rectangle(p.x, p.y, c.getWidth(), c.getHeight()));
            w.setLocation(location);
            RescaleOp op = new RescaleOp(1.0f + this.filterFactor, 0.0f, null);
            this.sshot = op.filter(this.sshot, null);
        }
        catch (AWTException aWTException) {
            // empty catch block
        }
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        if (this.sshot == null) {
            this.capture(c);
        }
        g.drawImage(this.sshot.getSubimage(x, y, this.sshot.getWidth() - x, this.sshot.getHeight() - y), x, y, c);
    }

    @Override
    public int getIconWidth() {
        return this.sshot.getWidth();
    }

    @Override
    public int getIconHeight() {
        return this.sshot.getHeight();
    }
}

