/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jcommon.ui;

import java.awt.Color;
import java.awt.color.ColorSpace;

public class RGBSwapColorSpace
extends ColorSpace {
    private int[] indices;

    public RGBSwapColorSpace(String order) {
        super(5, 3);
        if (order.length() != 3) {
            throw new IllegalArgumentException("The order parameter must contain exactly 3 characters.");
        }
        this.indices = new int[3];
        int i = 0;
        while (i < 3) {
            char c = order.charAt(i);
            switch (c) {
                case 'R': 
                case 'r': {
                    this.indices[i] = 0;
                    break;
                }
                case 'G': 
                case 'g': {
                    this.indices[i] = 1;
                    break;
                }
                case 'B': 
                case 'b': {
                    this.indices[i] = 2;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("The order parameter must contain only 'r', 'R', 'g', 'G', 'b', 'B' characters.");
                }
            }
            ++i;
        }
    }

    @Override
    public float[] toRGB(float[] colorvalue) {
        float[] x = new float[colorvalue.length];
        int i = 0;
        while (i < 3) {
            x[this.indices[i]] = colorvalue[i];
            ++i;
        }
        System.arraycopy(colorvalue, 3, x, 3, colorvalue.length - 3);
        return x;
    }

    @Override
    public float[] fromRGB(float[] colorvalue) {
        float[] x = new float[colorvalue.length];
        int i = 0;
        while (i < 3) {
            x[i] = colorvalue[this.indices[i]];
            ++i;
        }
        System.arraycopy(colorvalue, 3, x, 3, colorvalue.length - 3);
        return x;
    }

    @Override
    public float[] toCIEXYZ(float[] colorvalue) {
        Color c = new Color(colorvalue[this.indices[0]], colorvalue[this.indices[1]], colorvalue[this.indices[2]]);
        return c.getColorComponents(ColorSpace.getInstance(1001), null);
    }

    @Override
    public float[] fromCIEXYZ(float[] colorvalue) {
        Color c = new Color(ColorSpace.getInstance(1001), colorvalue, 0.0f);
        float[] rgbValues = c.getRGBColorComponents(null);
        float[] x = new float[3];
        int i = 0;
        while (i < 3) {
            x[this.indices[i]] = rgbValues[i];
            ++i;
        }
        return x;
    }
}

