/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jcommon.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.tree.TreePath;

public class PopupUtils {
    private PopupUtils() {
    }

    public static void install(JPopupMenu popup, Component component) {
        if (component instanceof JTable) {
            PopupUtils.install(popup, (JTable)component);
        } else if (component instanceof JTree) {
            PopupUtils.install(popup, (JTree)component);
        } else {
            component.addMouseListener(new ComponentPopupListener(popup));
        }
    }

    public static void install(JPopupMenu popup, JTable table) {
        table.addMouseListener(new TablePopupMouseListener(popup, table));
    }

    public static void install(JPopupMenu popup, JTree tree) {
        tree.addMouseListener(new TreePopupMouseListener(popup, tree));
    }

    public static class ComponentPopupListener
    extends MouseAdapter {
        private JPopupMenu popup;

        public ComponentPopupListener(JPopupMenu popup) {
            this.popup = popup;
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        private void maybeShowPopup(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this.popup.show(e.getComponent(), e.getX(), e.getY());
            }
        }
    }

    private static class TablePopupMouseListener
    extends MouseAdapter {
        private JPopupMenu popup;
        private JTable table;

        public TablePopupMouseListener(JPopupMenu ppopup, JTable ptable) {
            this.popup = ppopup;
            this.table = ptable;
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        private void maybeShowPopup(MouseEvent ev) {
            if (!SwingUtilities.isRightMouseButton(ev) && !ev.isPopupTrigger()) {
                return;
            }
            int prow = this.table.rowAtPoint(ev.getPoint());
            if (prow >= 0 && prow < this.table.getRowCount()) {
                if (!this.table.isRowSelected(prow) && this.table.getRowSelectionAllowed()) {
                    this.table.setRowSelectionInterval(prow, prow);
                }
            } else {
                return;
            }
            int pcol = this.table.columnAtPoint(ev.getPoint());
            if (pcol >= 0 && pcol < this.table.getColumnCount()) {
                if (!this.table.isColumnSelected(pcol) && this.table.getColumnSelectionAllowed()) {
                    this.table.setColumnSelectionInterval(pcol, pcol);
                }
            } else {
                return;
            }
            int x = ev.getX();
            int y = ev.getY();
            this.popup.pack();
            Point pt = this.table.getLocationOnScreen();
            Dimension screenDimension = Toolkit.getDefaultToolkit().getScreenSize();
            Dimension dim = this.popup.getPreferredSize();
            if ((double)x + pt.getX() + dim.getWidth() > screenDimension.getWidth()) {
                x -= (int)dim.getWidth();
            }
            if ((double)y + pt.getY() + 2.0 * dim.getHeight() > screenDimension.getHeight()) {
                y -= (int)dim.getHeight();
            }
            this.popup.show(this.table, x, y);
        }
    }

    private static class TreePopupMouseListener
    extends MouseAdapter {
        private JPopupMenu popup;
        private JTree tree;

        public TreePopupMouseListener(JPopupMenu popup, JTree tree) {
            this.popup = popup;
            this.tree = tree;
        }

        @Override
        public void mouseReleased(MouseEvent ev) {
            if (!SwingUtilities.isRightMouseButton(ev) && !ev.isPopupTrigger()) {
                return;
            }
            int x = ev.getX();
            int y = ev.getY();
            JPopupMenu nodePopup = this.popup;
            if (nodePopup == null) {
                return;
            }
            TreePath path = this.tree.getPathForLocation(ev.getX(), ev.getY());
            if (path != null) {
                TreePath[] selPaths = this.tree.getSelectionPaths();
                boolean sel = false;
                if (selPaths != null) {
                    int i = 0;
                    while (i < selPaths.length) {
                        if (path.equals(selPaths[i])) {
                            sel = true;
                            break;
                        }
                        ++i;
                    }
                }
                if (!sel) {
                    this.tree.setSelectionPath(path);
                }
            }
            Point pt = this.tree.getLocationOnScreen();
            Dimension screenDimension = Toolkit.getDefaultToolkit().getScreenSize();
            Dimension dim = this.popup.getPreferredSize();
            if ((double)x + pt.getX() + dim.getWidth() > screenDimension.getWidth()) {
                x -= (int)dim.getWidth();
            }
            if ((double)y + pt.getY() + 2.0 * dim.getHeight() > screenDimension.getHeight()) {
                y -= (int)dim.getHeight();
            }
            nodePopup.pack();
            nodePopup.show(this.tree, x, y);
        }
    }
}

