/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jcommon.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import net.sf.jcommon.ui.UIUtils;

public class OKCancelDialog
extends JDialog {
    public static final int PADDING = 3;
    protected JButton okButton;
    protected JButton cancelButton;
    protected JPanel buttonsPanel;
    private boolean canceled = true;
    private boolean isNew = true;
    private KeyListener escapeKL = new KeyAdapter(){

        @Override
        public void keyPressed(KeyEvent ev) {
            if (ev.getKeyCode() == 27) {
                OKCancelDialog.this.cancel();
            }
            if (ev.getKeyCode() == 10) {
                OKCancelDialog.this.ok();
            }
        }
    };
    private ContainerListener escapeCL = new ContainerListener(){

        @Override
        public void componentAdded(ContainerEvent e) {
            OKCancelDialog.this.addEscapeKL(e.getChild());
        }

        @Override
        public void componentRemoved(ContainerEvent e) {
            OKCancelDialog.this.removeEscapeKL(e.getChild());
        }
    };

    private void addEscapeKL(Component c) {
        c.addKeyListener(this.escapeKL);
        if (c instanceof Container) {
            Container x = (Container)c;
            x.addContainerListener(this.escapeCL);
            int n = x.getComponentCount();
            int i = 0;
            while (i < n) {
                this.addEscapeKL(x.getComponent(i));
                ++i;
            }
        }
    }

    private void removeEscapeKL(Component c) {
        c.removeKeyListener(this.escapeKL);
        if (c instanceof Container) {
            Container x = (Container)c;
            x.removeContainerListener(this.escapeCL);
            int n = x.getComponentCount();
            int i = 0;
            while (i < n) {
                this.removeEscapeKL(x.getComponent(i));
                ++i;
            }
        }
    }

    public OKCancelDialog() {
        this.init();
    }

    public OKCancelDialog(Frame owner) {
        super(owner);
        this.init();
    }

    public OKCancelDialog(Dialog owner) {
        super(owner);
        this.init();
    }

    public OKCancelDialog(Frame owner, String title) {
        super(owner, title);
        this.init();
    }

    public OKCancelDialog(Dialog owner, String title) {
        super(owner, title);
        this.init();
    }

    private void init() {
        this.okButton = new JButton(UIUtils.getUIString("OKCancelDialog.okButtonText", "OK"));
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                OKCancelDialog.this.ok();
            }
        });
        this.cancelButton = new JButton(UIUtils.getUIString("OKCancelDialog.cancelButtonText", "Cancel"));
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                OKCancelDialog.this.cancel();
            }
        });
        this.buttonsPanel = new JPanel();
        this.buttonsPanel.setLayout(new BoxLayout(this.buttonsPanel, 0));
        this.buttonsPanel.add(Box.createGlue());
        this.buttonsPanel.add(this.okButton);
        this.buttonsPanel.add(Box.createHorizontalStrut(3));
        this.buttonsPanel.add(this.cancelButton);
        this.setModal(true);
        JPanel newContent = new JPanel();
        newContent.setLayout(new BorderLayout(3, 3));
        newContent.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        newContent.add((Component)this.buttonsPanel, "South");
        this.setContentPane(newContent);
        this.getContentPane().addKeyListener(this.escapeKL);
        this.getContentPane().addContainerListener(this.escapeCL);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowActivated(WindowEvent e) {
                if (OKCancelDialog.this.isNew) {
                    OKCancelDialog.this.resetFocus();
                    OKCancelDialog.this.isNew = false;
                }
            }
        });
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public JButton getOKButton() {
        return this.okButton;
    }

    public JButton getCancelButton() {
        return this.cancelButton;
    }

    protected void cancel() {
        this.canceled = true;
        this.setVisible(false);
    }

    protected void ok() {
        this.canceled = false;
        this.setVisible(false);
    }

    @Override
    public void setVisible(boolean b) {
        if (b) {
            this.canceled = true;
            this.setLocationRelativeTo(this.getParent());
            super.setVisible(true);
        } else if (this.canceled || this.validateUserInput()) {
            this.isNew = true;
            super.setVisible(false);
        } else {
            this.canceled = true;
        }
    }

    protected boolean validateUserInput() {
        return true;
    }

    protected void resetFocus() {
    }
}

