/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jcommon.ui;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.JViewport;

public class MouseDragScroller
implements MouseListener,
MouseMotionListener {
    public static final int MOVE_COMPONENT = 1;
    public static final int MOVE_VIEWPORT = -1;
    private int scrollMode = 1;
    private double tolerance = 0.0;
    private Cursor scrollCursor;
    private Point previous;
    private Cursor normalCursor;

    public MouseDragScroller() {
        this(1);
    }

    public MouseDragScroller(int scrollMode) {
        this(scrollMode, Cursor.getPredefinedCursor(13));
    }

    public MouseDragScroller(int scrollMode, Cursor scrollCursor) {
        if (scrollMode != 1 && scrollMode != -1) {
            throw new IllegalArgumentException("The scroll mode can be only MOVE_COMPONENT or MOVE_VIEWPORT");
        }
        this.scrollMode = scrollMode;
        this.scrollCursor = scrollCursor;
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.moveTo(e.getSource(), e.getPoint());
    }

    private void moveTo(Object source, Point newPoint) {
        if (source instanceof Component && ((Component)source).getParent() instanceof JViewport) {
            Point newViewPoint;
            Component c = (Component)source;
            JViewport viewport = (JViewport)c.getParent();
            double diffx = newPoint.getX() - this.previous.getX();
            double diffy = newPoint.getY() - this.previous.getY();
            if (Math.abs(diffx) <= this.tolerance && Math.abs(diffy) <= this.tolerance) {
                return;
            }
            Point viewPoint = viewport.getViewPosition();
            double x = viewPoint.getX() - (double)this.scrollMode * diffx;
            double y = viewPoint.getY() - (double)this.scrollMode * diffy;
            if (x < 0.0) {
                x = 0.0;
            }
            if (y < 0.0) {
                y = 0.0;
            }
            double maxx = viewport.getViewSize().getWidth() - viewport.getExtentSize().getWidth();
            double maxy = viewport.getViewSize().getHeight() - viewport.getExtentSize().getHeight();
            if (x > maxx) {
                x = maxx;
            }
            if (y > maxy) {
                y = maxy;
            }
            if (!viewPoint.equals(newViewPoint = new Point((int)x, (int)y))) {
                viewport.setViewPosition(newViewPoint);
            }
            if (this.scrollMode == -1) {
                this.previous = newPoint;
            }
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.previous = e.getPoint();
        if (this.scrollCursor != null && e.getSource() instanceof Component) {
            this.normalCursor = ((Component)e.getSource()).getCursor();
            ((Component)e.getSource()).setCursor(this.scrollCursor);
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (this.normalCursor != null && e.getSource() instanceof Component) {
            ((Component)e.getSource()).setCursor(this.normalCursor);
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }
}

