/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jcommon.ui;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import net.sf.jcommon.ui.UIUtils;

public class JTextPopup
extends JPopupMenu {
    private JTextComponent c;
    private JMenuItem cut;
    private JMenuItem copy;
    private JMenuItem paste;
    private JMenuItem delete;
    private JMenuItem selectAll;

    public JTextPopup() {
        this.init();
    }

    private void init() {
        this.cut = new JMenuItem(UIUtils.getUIString("TextPopup.cutText", "Cut"));
        this.cut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JTextPopup.this.c.cut();
            }
        });
        this.copy = new JMenuItem(UIUtils.getUIString("TextPopup.copyText", "Copy"));
        this.copy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JTextPopup.this.c.copy();
            }
        });
        this.paste = new JMenuItem(UIUtils.getUIString("TextPopup.pasteText", "Paste"));
        this.paste.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JTextPopup.this.c.paste();
            }
        });
        this.delete = new JMenuItem(UIUtils.getUIString("TextPopup.deleteText", "Delete"));
        this.delete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    JTextPopup.this.c.getDocument().remove(JTextPopup.this.c.getSelectionStart(), JTextPopup.this.c.getSelectionEnd() - JTextPopup.this.c.getSelectionStart());
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
        });
        this.selectAll = new JMenuItem(UIUtils.getUIString("TextPopup.selectAllText", "Select All"));
        this.selectAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JTextPopup.this.c.selectAll();
            }
        });
        this.add(this.cut);
        this.add(this.copy);
        this.add(this.paste);
        this.add(this.delete);
        this.addSeparator();
        this.add(this.selectAll);
    }

    @Override
    public void show(Component invoker, int x, int y) {
        if (invoker instanceof JTextComponent) {
            this.c = (JTextComponent)invoker;
            boolean enabled = this.c.isEnabled();
            boolean editable = this.c.isEditable();
            boolean hasSelection = this.c.getSelectedText() != null;
            this.cut.setEnabled(enabled && hasSelection && editable);
            this.copy.setEnabled(enabled && hasSelection);
            this.paste.setEnabled(enabled && editable);
            this.delete.setEnabled(enabled && hasSelection && editable);
            this.paste.setEnabled(enabled && editable);
            this.selectAll.setEnabled(enabled);
            super.show(invoker, x, y);
        }
    }

    @Override
    public void updateUI() {
        super.updateUI();
        if (this.cut != null) {
            this.cut.setText(UIUtils.getUIString("TextPopup.cutText", "Cut"));
            this.copy.setText(UIUtils.getUIString("TextPopup.copyText", "Copy"));
            this.paste.setText(UIUtils.getUIString("TextPopup.pasteText", "Paste"));
            this.delete.setText(UIUtils.getUIString("TextPopup.deleteText", "Delete"));
            this.selectAll.setText(UIUtils.getUIString("TextPopup.selectAllText", "Select All"));
        }
    }
}

