/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jcommon.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JViewport;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.sf.jcommon.ui.ArrowButton;

public class JSimpleScrollPane
extends JComponent {
    public static final int ALWAYS = 1;
    public static final int AS_NEEDED = 2;
    public static final int NEVER = 3;
    private int horizontalButtonPolicy;
    private int verticalButtonPolicy;
    private int unitScrollAmount = 5;
    private int blockScrollAmount = 20;
    private int scrollSpeedThrottle = 60;
    private int wheelScrollSpeed = 10;
    private JViewport viewport;
    private JButton upButton;
    private JButton downButton;
    private JButton leftButton;
    private JButton rightButton;
    private ScrollListener scrollListener = new ScrollListener();
    private Timer scrollTimer = new Timer(this.scrollSpeedThrottle, this.scrollListener);
    private ViewportChangeListener viewportChangeListener = new ViewportChangeListener();
    private ViewportMouseWheelListener viewportMouseWheelListener = new ViewportMouseWheelListener();

    public JSimpleScrollPane(JComponent view) {
        this(view, 2, 2);
    }

    public JSimpleScrollPane(JComponent view, int horizontalButtonPolicy, int verticalButtonPolicy) {
        this.horizontalButtonPolicy = horizontalButtonPolicy;
        this.verticalButtonPolicy = verticalButtonPolicy;
        this.init();
        this.setViewport(new JViewport());
        this.getViewport().setView(view);
    }

    private JButton createScrollButton(final int direction) {
        ArrowButton scrollButton = new ArrowButton(direction, 1, 10);
        scrollButton.setFocusPainted(false);
        scrollButton.setFocusable(false);
        scrollButton.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(0), BorderFactory.createEmptyBorder(2, 2, 2, 2)));
        scrollButton.setBackground(UIManager.getColor("ScrollBar.background"));
        scrollButton.setForeground(UIManager.getColor("ScrollBar.thumb").darker());
        scrollButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JSimpleScrollPane.this.scroll(direction, JSimpleScrollPane.this.blockScrollAmount);
            }
        });
        scrollButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                JSimpleScrollPane.this.scrollListener.direction = direction;
                JSimpleScrollPane.this.scrollTimer.start();
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                JSimpleScrollPane.this.scrollTimer.stop();
            }
        });
        return scrollButton;
    }

    private void init() {
        this.setLayout(new BorderLayout());
        this.upButton = this.createScrollButton(1);
        this.downButton = this.createScrollButton(5);
        this.leftButton = this.createScrollButton(7);
        this.rightButton = this.createScrollButton(3);
        this.add((Component)this.upButton, "North");
        this.add((Component)this.downButton, "South");
        this.add((Component)this.leftButton, "West");
        this.add((Component)this.rightButton, "East");
    }

    private void scroll(int direction, int amount) {
        int x = (int)this.viewport.getViewPosition().getX();
        int y = (int)this.viewport.getViewPosition().getY();
        switch (direction) {
            case 1: {
                y -= amount;
                break;
            }
            case 5: {
                y += amount;
                break;
            }
            case 7: {
                x -= amount;
                break;
            }
            case 3: {
                x += amount;
            }
        }
        if (x < 0) {
            x = 0;
        }
        if (x > (int)(this.viewport.getViewSize().getWidth() - this.viewport.getExtentSize().getWidth())) {
            x = (int)(this.viewport.getViewSize().getWidth() - this.viewport.getExtentSize().getWidth());
        }
        if (y < 0) {
            y = 0;
        }
        if (y > (int)(this.viewport.getViewSize().getHeight() - this.viewport.getExtentSize().getHeight())) {
            y = (int)(this.viewport.getViewSize().getHeight() - this.viewport.getExtentSize().getHeight());
        }
        this.viewport.setViewPosition(new Point(x, y));
    }

    public int getHorizontalButtonPolicy() {
        return this.horizontalButtonPolicy;
    }

    public void setHorizontalButtonPolicy(int horizontalButtonPolicy) {
        this.horizontalButtonPolicy = horizontalButtonPolicy;
        this.leftButton.setVisible(horizontalButtonPolicy == 1);
        this.rightButton.setVisible(horizontalButtonPolicy == 1);
        this.updateButtonsVisibility();
    }

    public int getVerticalButtonPolicy() {
        return this.verticalButtonPolicy;
    }

    public void setVerticalButtonPolicy(int verticalButtonPolicy) {
        this.verticalButtonPolicy = verticalButtonPolicy;
        this.upButton.setVisible(verticalButtonPolicy == 1);
        this.downButton.setVisible(verticalButtonPolicy == 1);
        this.updateButtonsVisibility();
    }

    public JViewport getViewport() {
        return this.viewport;
    }

    public void setViewport(JViewport viewport) {
        if (this.viewport != null) {
            this.viewport.removeChangeListener(this.viewportChangeListener);
        }
        if (this.viewport != null) {
            this.viewport.removeMouseWheelListener(this.viewportMouseWheelListener);
        }
        this.viewport = viewport;
        this.add((Component)viewport, "Center");
        viewport.addChangeListener(this.viewportChangeListener);
        viewport.addMouseWheelListener(this.viewportMouseWheelListener);
        this.updateButtonsVisibility();
    }

    private void updateButtonsVisibility() {
        boolean verticalButtonsVisible = this.viewport.getExtentSize().getHeight() < this.viewport.getViewSize().getHeight() && this.verticalButtonPolicy != 3;
        this.upButton.setVisible(verticalButtonsVisible);
        this.downButton.setVisible(verticalButtonsVisible);
        boolean horizontalButtonsVisible = this.viewport.getExtentSize().getWidth() < this.viewport.getViewSize().getWidth() && this.horizontalButtonPolicy != 3;
        this.leftButton.setVisible(horizontalButtonsVisible);
        this.rightButton.setVisible(horizontalButtonsVisible);
    }

    private class ScrollListener
    implements ActionListener {
        private int direction = 0;
        private int amount;

        private ScrollListener() {
            this.amount = JSimpleScrollPane.this.unitScrollAmount;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JSimpleScrollPane.this.scroll(this.direction, this.amount);
        }
    }

    private class ViewportChangeListener
    implements ChangeListener {
        private ViewportChangeListener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            JSimpleScrollPane.this.updateButtonsVisibility();
        }
    }

    private class ViewportMouseWheelListener
    implements MouseWheelListener {
        private ViewportMouseWheelListener() {
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent e) {
            if (e.getScrollType() == 1) {
                JSimpleScrollPane.this.scroll(e.getScrollAmount() < 0 ? 1 : 5, Math.abs(e.getScrollAmount()) * JSimpleScrollPane.this.wheelScrollSpeed);
            }
            if (e.getScrollType() == 0) {
                JSimpleScrollPane.this.scroll(e.getUnitsToScroll() < 0 ? 1 : 5, Math.abs(e.getUnitsToScroll()) * JSimpleScrollPane.this.wheelScrollSpeed);
            }
        }
    }
}

