/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jcommon.ui;

import java.awt.Cursor;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import net.sf.jcommon.ui.ComposedIcon;

public class IconsCache {
    private Class<?> resourceClass;
    private String resourcePath;
    private Map<String, Icon> icons = new HashMap<String, Icon>();
    private Map<String, Cursor> cursors = new HashMap<String, Cursor>();

    public IconsCache(Class<?> resourceClass) {
        this(resourceClass, "img");
    }

    public IconsCache(Class<?> resourceClass, String resourcePath) {
        this.resourceClass = resourceClass;
        this.resourcePath = resourcePath == null || resourcePath.trim().length() == 0 ? "" : String.valueOf(resourcePath.trim()) + (resourcePath.endsWith("/") ? "" : "/");
    }

    public Image getImage(String name) {
        Icon icon = this.getIcon(name);
        return icon instanceof ImageIcon ? ((ImageIcon)icon).getImage() : null;
    }

    public Icon getIcon(String name) {
        Icon icon = this.icons.get(name);
        if (icon == null && (icon = this.createIcon(name)) != null) {
            this.icons.put(name, icon);
        }
        return icon;
    }

    private Icon createIcon(String name) {
        URL url;
        if (name.indexOf("&") >= 0) {
            ArrayList<Icon> icons = new ArrayList<Icon>();
            StringTokenizer st = new StringTokenizer(name, "&", false);
            while (st.hasMoreTokens()) {
                icons.add(this.getIcon(st.nextToken()));
            }
            return new ComposedIcon(icons.toArray(new Icon[icons.size()]));
        }
        String name2 = name.toLowerCase();
        if (name2.endsWith(".png") || name2.endsWith(".gif") || name2.endsWith(".jpg") || name2.endsWith(".jpeg")) {
            url = this.resourceClass.getResource(String.valueOf(this.resourcePath) + name);
        } else {
            url = this.resourceClass.getResource(String.valueOf(this.resourcePath) + name + ".png");
            if (url == null) {
                url = this.resourceClass.getResource(String.valueOf(this.resourcePath) + name + ".gif");
            }
            if (url == null) {
                url = this.resourceClass.getResource(String.valueOf(this.resourcePath) + name + ".jpg");
            }
        }
        return url != null ? new ImageIcon(url) : null;
    }

    private Cursor createCursor(String name) {
        return Toolkit.getDefaultToolkit().createCustomCursor(this.getImage(name), new Point(0, 0), name);
    }

    public Cursor getCursor(String name) {
        Cursor cursor = this.cursors.get(name);
        if (cursor == null) {
            cursor = this.createCursor(name);
            this.cursors.put(name, cursor);
        }
        return cursor;
    }
}

