/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jcommon.ui;

import java.awt.Color;
import java.awt.Graphics;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.plaf.basic.BasicButtonUI;

public class HighlightButtonUI
extends BasicButtonUI {
    private Color selectedBackground;
    private Color hoverBackground;
    private Color selectedBorder;
    private Color hoverBorder;

    public HighlightButtonUI() {
    }

    public HighlightButtonUI(Color selectedBackground, Color selectedBorder, Color hoverBackground, Color hoverBorder) {
        this.selectedBackground = selectedBackground;
        this.hoverBackground = hoverBackground;
        this.selectedBorder = selectedBorder;
        this.hoverBorder = hoverBorder;
    }

    public Color getSelectedBackground() {
        return this.selectedBackground;
    }

    public void setSelectedBackground(Color selectedBackground) {
        this.selectedBackground = selectedBackground;
    }

    public Color getHoverBackground() {
        return this.hoverBackground;
    }

    public void setHoverBackground(Color hoverBackground) {
        this.hoverBackground = hoverBackground;
    }

    public Color getSelectedBorder() {
        return this.selectedBorder;
    }

    public void setSelectedBorder(Color selectedBorder) {
        this.selectedBorder = selectedBorder;
    }

    public Color getHoverBorder() {
        return this.hoverBorder;
    }

    public void setHoverBorder(Color hoverBorder) {
        this.hoverBorder = hoverBorder;
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        AbstractButton button = (AbstractButton)c;
        button.setRolloverEnabled(true);
        button.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        AbstractButton button = (AbstractButton)c;
        if (button.getModel().isRollover() || button.getModel().isArmed() || button.getModel().isSelected()) {
            Color oldColor = g.getColor();
            Color selBg = this.selectedBackground != null ? this.selectedBackground : button.getBackground().darker();
            Color selBorder = this.selectedBorder != null ? this.selectedBorder : selBg.darker().darker();
            Color hoBg = this.hoverBackground != null ? this.hoverBackground : button.getBackground().brighter();
            Color hoBorder = this.hoverBorder != null ? this.hoverBorder : hoBg.darker().darker();
            g.setColor(button.getModel().isSelected() ? selBg : hoBg);
            g.fillRect(0, 0, c.getWidth() - 1, c.getHeight() - 1);
            g.setColor(button.getModel().isSelected() ? selBorder : hoBorder);
            g.drawRect(0, 0, c.getWidth() - 1, c.getHeight() - 1);
            g.setColor(oldColor);
        }
        super.paint(g, c);
    }
}

