/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jcommon.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class FileField
extends JPanel {
    private JTextField fileTextField;
    private JFileChooser fileChooser;
    private String dialogTitle;
    private int dialogType;
    private Collection<ChangeListener> changeListeners = new ArrayList<ChangeListener>();
    private JButton browseButton;

    private JFileChooser getFileChooser() {
        if (this.fileChooser == null) {
            this.fileChooser = new JFileChooser();
            this.fileChooser.setMultiSelectionEnabled(false);
            this.fileChooser.setAcceptAllFileFilterUsed(true);
            this.fileChooser.setDialogTitle(this.dialogTitle);
            this.fileChooser.setDialogType(this.dialogType);
            this.fileChooser.setFileSelectionMode(2);
        }
        return this.fileChooser;
    }

    public FileField(String dialogTitle, int dialogType) {
        this.dialogTitle = dialogTitle;
        this.dialogType = dialogType;
        this.init();
    }

    private void init() {
        this.fileTextField = new JTextField(30);
        this.fileTextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                FileField.this.fireChangeListeners();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                FileField.this.fireChangeListeners();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                FileField.this.fireChangeListeners();
            }
        });
        this.browseButton = new JButton("...");
        this.browseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FileField.this.browse();
            }
        });
        this.setLayout(new BorderLayout());
        this.add(this.fileTextField);
        this.add((Component)this.browseButton, "East");
    }

    protected void fireChangeListeners() {
        ChangeEvent event = new ChangeEvent(this);
        for (ChangeListener l : this.changeListeners) {
            l.stateChanged(event);
        }
    }

    public void addChangeListener(ChangeListener listener) {
        this.changeListeners.add(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.changeListeners.remove(listener);
    }

    private void browse() {
        int retval;
        this.getFileChooser();
        File selectedFile = new File(this.fileTextField.getText());
        if (selectedFile.exists()) {
            this.fileChooser.setCurrentDirectory(selectedFile.getParentFile());
            this.fileChooser.setSelectedFile(selectedFile);
        }
        if ((retval = this.dialogType == 0 ? this.fileChooser.showOpenDialog(this.fileTextField) : this.fileChooser.showSaveDialog(this.fileTextField)) == 0) {
            this.fileTextField.setText(this.fileChooser.getSelectedFile().getAbsolutePath());
        }
    }

    @Override
    public void requestFocus() {
        this.fileTextField.requestFocus();
    }

    public String getPath() {
        return this.fileTextField.getText();
    }

    public void setPath(String path) {
        this.fileTextField.setText(path);
    }

    public int getFileSelectionMode() {
        return this.getFileChooser().getFileSelectionMode();
    }

    public void setFileSelectionMode(int mode) {
        this.getFileChooser().setFileSelectionMode(mode);
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.fileTextField.setEnabled(enabled);
        this.browseButton.setEnabled(enabled);
    }
}

