/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jcommon.ui;

import java.awt.Component;
import java.awt.Graphics;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.Icon;

public class DynamicComposedIcon
implements Icon {
    private static final Delta2D NO_DELTA = new Delta2D(0, 0);
    private List<Icon> icons;
    private List<Delta2D> deltas;
    private int width;
    private int height;

    public DynamicComposedIcon() {
        this.icons = new ArrayList<Icon>();
        this.deltas = new ArrayList<Delta2D>();
    }

    private void resetSize() {
        this.width = -1;
        this.height = -1;
    }

    private int getDeltaX(int i) {
        return this.deltas.get(i).getX();
    }

    private int getDeltaY(int i) {
        return this.deltas.get(i).getY();
    }

    private Icon getIcon(int i) {
        return this.icons.get(i);
    }

    public DynamicComposedIcon(Icon ... icons) {
        this.icons = Arrays.asList(icons);
        this.deltas = new ArrayList<Delta2D>(icons.length);
        int i = 0;
        while (i < this.icons.size()) {
            this.deltas.add(NO_DELTA);
            ++i;
        }
        this.resetSize();
    }

    public DynamicComposedIcon(Icon[] icons, int[] deltaXs, int[] deltaYs) {
        this.icons = Arrays.asList(icons);
        this.deltas = new ArrayList<Delta2D>(icons.length);
        int i = 0;
        while (i < this.icons.size()) {
            this.deltas.add(new Delta2D(deltaXs[i], deltaYs[i]));
            ++i;
        }
        this.resetSize();
    }

    public void addIcon(Icon icon) {
        this.icons.add(icon);
        this.deltas.add(NO_DELTA);
        this.resetSize();
    }

    public void addIcon(Icon icon, int deltaX, int deltaY) {
        this.icons.add(icon);
        this.deltas.add(new Delta2D(deltaX, deltaY));
        this.resetSize();
    }

    @Override
    public int getIconHeight() {
        if (this.height < 0) {
            int i = 0;
            while (i < this.icons.size()) {
                int h = this.getIcon(i).getIconHeight() + this.getDeltaY(i);
                if (h > this.height) {
                    this.height = h;
                }
                ++i;
            }
        }
        return this.height;
    }

    @Override
    public int getIconWidth() {
        if (this.width < 0) {
            int i = 0;
            while (i < this.icons.size()) {
                int w = this.getIcon(i).getIconWidth() + this.getDeltaX(i);
                if (w > this.width) {
                    this.width = w;
                }
                ++i;
            }
        }
        return this.width;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        int i = 0;
        while (i < this.icons.size()) {
            this.getIcon(i).paintIcon(c, g, x + this.getDeltaX(i), y + this.getDeltaY(i));
            ++i;
        }
    }

    private static class Delta2D {
        private int x;
        private int y;

        public Delta2D(int x, int y) {
            this.x = x;
            this.y = y;
        }

        public int getX() {
            return this.x;
        }

        public int getY() {
            return this.y;
        }
    }
}

