/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jcommon.ui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.Timer;

public class CountdownButton
extends JButton {
    private Timer timer;
    private int secondsToShow;
    private int secondsElapsed;

    public CountdownButton(String text, int secondsToShow) {
        super(text);
        this.secondsToShow = secondsToShow;
        this.init();
    }

    public CountdownButton(Action a, int secondsToShow) {
        super(a);
        this.secondsToShow = secondsToShow;
        this.init();
    }

    public CountdownButton(Icon icon, int secondsToShow) {
        super(icon);
        this.secondsToShow = secondsToShow;
        this.init();
    }

    public CountdownButton(String text, Icon icon, int secondsToShow) {
        super(text, icon);
        this.secondsToShow = secondsToShow;
        this.init();
    }

    private void init() {
        this.timer = new Timer(1000, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CountdownButton countdownButton = CountdownButton.this;
                countdownButton.secondsElapsed = countdownButton.secondsElapsed + 1;
                CountdownButton.this.repaint();
                if (CountdownButton.this.secondsElapsed >= CountdownButton.this.secondsToShow) {
                    CountdownButton.this.doClick();
                }
            }
        });
        this.timer.setRepeats(true);
        this.timer.setInitialDelay(1000);
        this.timer.setDelay(1000);
    }

    public void start() {
        this.secondsElapsed = 0;
        this.timer.start();
    }

    public void restart() {
        this.secondsElapsed = 0;
        this.timer.restart();
    }

    public void stop() {
        this.timer.stop();
    }

    @Override
    public String getText() {
        return String.valueOf(super.getText()) + " (" + (this.secondsToShow - this.secondsElapsed) + ")";
    }
}

