/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jcommon.ui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JButton;

public class ArrowButton
extends JButton {
    private static final Insets NO_INSETS = new Insets(0, 0, 0, 0);
    private int direction;
    private int arrowCount;
    private int arrowSize;

    public ArrowButton(int direction, int arrowCount, int arrowSize) {
        this.setMargin(new Insets(0, 2, 0, 2));
        this.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.direction = direction;
        this.arrowCount = arrowCount;
        this.arrowSize = arrowSize;
    }

    public int getDirection() {
        return this.direction;
    }

    public void setDirection(int direction) {
        this.direction = direction;
    }

    public int getArrowCount() {
        return this.arrowCount;
    }

    public void setArrowCount(int arrowCount) {
        this.arrowCount = arrowCount;
    }

    public int getArrowSize() {
        return this.arrowSize;
    }

    public void setArrowSize(int arrowSize) {
        this.arrowSize = arrowSize;
    }

    @Override
    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    @Override
    public Dimension getMinimumSize() {
        Insets borderInsets = this.getBorder() == null ? NO_INSETS : this.getBorder().getBorderInsets(this);
        return new Dimension(this.arrowSize * (this.direction == 3 || this.direction == 7 ? this.arrowCount : 3) + borderInsets.left + borderInsets.right, this.arrowSize * (this.direction == 1 || this.direction == 5 ? this.arrowCount : 3) + borderInsets.top + borderInsets.bottom);
    }

    @Override
    public Dimension getMaximumSize() {
        return this.getMinimumSize();
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Color oldColor = g.getColor();
        g.setColor(this.isEnabled() ? this.getForeground() : this.getForeground().brighter());
        int w = this.getSize().width;
        int h = this.getSize().height;
        int i = 0;
        while (i < this.arrowCount) {
            this.paintArrow(g, (w - this.arrowSize * (this.direction == 3 || this.direction == 7 ? this.arrowCount : 1)) / 2 + this.arrowSize * (this.direction == 3 || this.direction == 7 ? i : 0), (h - this.arrowSize * (this.direction == 3 || this.direction == 7 ? 1 : this.arrowCount)) / 2 + this.arrowSize * (this.direction == 3 || this.direction == 7 ? 0 : i), g.getColor());
            ++i;
        }
        g.setColor(oldColor);
    }

    private void paintArrow(Graphics g, int x, int y, Color highlight) {
        Color oldColor = g.getColor();
        boolean isEnabled = this.isEnabled();
        int j = 0;
        this.arrowSize = Math.max(this.arrowSize, 2);
        int mid = this.arrowSize / 2 - 1;
        g.translate(x, y);
        switch (this.direction) {
            case 1: {
                int i = 0;
                while (i < this.arrowSize) {
                    g.drawLine(mid - i, i, mid + i, i);
                    ++i;
                }
                if (isEnabled) break;
                g.setColor(highlight);
                g.drawLine(mid - i + 2, i, mid + i, i);
                break;
            }
            case 5: {
                int i;
                if (!isEnabled) {
                    g.translate(1, 1);
                    g.setColor(highlight);
                    i = this.arrowSize - 1;
                    while (i >= 0) {
                        g.drawLine(mid - i, j, mid + i, j);
                        ++j;
                        --i;
                    }
                    g.translate(-1, -1);
                    g.setColor(oldColor);
                }
                j = 0;
                i = this.arrowSize - 1;
                while (i >= 0) {
                    g.drawLine(mid - i, j, mid + i, j);
                    ++j;
                    --i;
                }
                break;
            }
            case 7: {
                int i = 0;
                while (i < this.arrowSize) {
                    g.drawLine(i, mid - i, i, mid + i);
                    ++i;
                }
                if (isEnabled) break;
                g.setColor(highlight);
                g.drawLine(i, mid - i + 2, i, mid + i);
                break;
            }
            case 3: {
                int i;
                if (!isEnabled) {
                    g.translate(1, 1);
                    g.setColor(highlight);
                    i = this.arrowSize - 1;
                    while (i >= 0) {
                        g.drawLine(j, mid - i, j, mid + i);
                        ++j;
                        --i;
                    }
                    g.translate(-1, -1);
                    g.setColor(oldColor);
                }
                j = 0;
                i = this.arrowSize - 1;
                while (i >= 0) {
                    g.drawLine(j, mid - i, j, mid + i);
                    ++j;
                    --i;
                }
                break;
            }
        }
        g.translate(-x, -y);
        g.setColor(oldColor);
    }
}

