/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jcommon.spring;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.Locale;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import net.sf.jcommon.web.RedirectedHttpServletResponse;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.ViewResolver;
import org.w3c.dom.Document;
import org.xhtmlrenderer.pdf.ITextRenderer;

public class Xhtml2PdfViewResolver
implements ViewResolver {
    private static final String PDF_MIME_TYPE = "application/pdf";
    private ViewResolver decoratedViewResolver;

    public Xhtml2PdfViewResolver(ViewResolver decoratedViewResolver) {
        this.decoratedViewResolver = decoratedViewResolver;
    }

    public View resolveViewName(String viewName, Locale locale) throws Exception {
        return this.decorate(this.decoratedViewResolver.resolveViewName(viewName, locale));
    }

    private View decorate(View view) {
        if (view == null) {
            return null;
        }
        return new Xhtml2PdfView(view);
    }

    private static class Xhtml2PdfView
    implements View {
        private View decoratedView;

        public Xhtml2PdfView(View decoratedView) {
            this.decoratedView = decoratedView;
        }

        public String getContentType() {
            return Xhtml2PdfViewResolver.PDF_MIME_TYPE;
        }

        public void render(Map<String, ?> model, HttpServletRequest request, HttpServletResponse response) throws Exception {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            this.decoratedView.render(model, request, (HttpServletResponse)new RedirectedHttpServletResponse(response, out));
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document doc = builder.parse(new ByteArrayInputStream(out.toByteArray()));
            ITextRenderer renderer = new ITextRenderer();
            renderer.setDocument(doc, null);
            renderer.layout();
            ServletOutputStream os = response.getOutputStream();
            renderer.createPDF((OutputStream)os);
        }
    }
}

