/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jcommon.spring;

import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import net.sf.jcommon.web.WebAttribute;
import org.springframework.core.MethodParameter;
import org.springframework.web.bind.support.WebArgumentResolver;
import org.springframework.web.context.ServletContextAware;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.context.request.ServletWebRequest;

public class WebAttributeArgumentResolver
implements WebArgumentResolver,
ServletContextAware {
    private ServletContext servletContext;

    public Object resolveArgument(MethodParameter methodParameter, NativeWebRequest webRequest) throws Exception {
        if (!(webRequest instanceof ServletWebRequest)) {
            return WebArgumentResolver.UNRESOLVED;
        }
        ServletWebRequest servletWebRequest = (ServletWebRequest)webRequest;
        WebAttribute annotation = (WebAttribute)methodParameter.getParameterAnnotation(WebAttribute.class);
        if (annotation != null) {
            Object value = null;
            switch (annotation.scope()) {
                case SESSION: {
                    HttpSession session = servletWebRequest.getRequest().getSession(false);
                    if (session == null) break;
                    value = session.getAttribute(annotation.value());
                    break;
                }
                case APPLICATION: {
                    value = this.servletContext.getAttribute(annotation.value());
                    break;
                }
                default: {
                    value = servletWebRequest.getRequest().getAttribute(annotation.value());
                }
            }
            if (value == null) {
                if (annotation.required()) {
                    throw new IllegalArgumentException("The attribute " + annotation.value() + " must be specified in " + (Object)((Object)annotation.scope()));
                }
                return null;
            }
            if (!methodParameter.getParameterType().isInstance(value)) {
                throw new ClassCastException("The attribute " + annotation.value() + " is not of the specified type.");
            }
            return value;
        }
        return WebArgumentResolver.UNRESOLVED;
    }

    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }
}

