/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jcommon.spring;

import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.NoResultException;
import javax.persistence.NonUniqueResultException;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.core.userdetails.UsernameNotFoundException;

public class JPUserDetailsService
implements UserDetailsService {
    private EntityManagerFactory entityManagerFactory;
    private Class<? extends UserDetails> userClass;
    private String usernameProperty;

    public JPUserDetailsService(EntityManagerFactory entityManagerFactory, Class<? extends UserDetails> userClass, String usernameProperty) {
        this.entityManagerFactory = entityManagerFactory;
        this.userClass = userClass;
        this.usernameProperty = usernameProperty;
    }

    public JPUserDetailsService(EntityManagerFactory entityManagerFactory, Class<? extends UserDetails> userClass) {
        this(entityManagerFactory, userClass, "username");
    }

    public JPUserDetailsService(Class<? extends UserDetails> userClass) {
        this(null, userClass);
    }

    public EntityManagerFactory getEntityManagerFactory() {
        return this.entityManagerFactory;
    }

    public void setEntityManagerFactory(EntityManagerFactory entityManagerFactory) {
        this.entityManagerFactory = entityManagerFactory;
    }

    public Class<? extends UserDetails> getUserClass() {
        return this.userClass;
    }

    public void setUserClass(Class<? extends UserDetails> userClass) {
        this.userClass = userClass;
    }

    public String getUsernameProperty() {
        return this.usernameProperty;
    }

    public void setUsernameProperty(String usernameProperty) {
        this.usernameProperty = usernameProperty;
    }

    public UserDetails loadUserByUsername(String username) throws UsernameNotFoundException {
        EntityManager em = this.entityManagerFactory.createEntityManager();
        CriteriaBuilder cb = em.getCriteriaBuilder();
        CriteriaQuery c = cb.createQuery(this.userClass);
        c.where((Expression)cb.equal((Expression)c.from(this.userClass).get(this.usernameProperty), (Object)username));
        try {
            return (UserDetails)em.createQuery(c).getSingleResult();
        }
        catch (NoResultException exc) {
            throw new UsernameNotFoundException("Username " + username + " not found", (Throwable)exc);
        }
        catch (NonUniqueResultException exc) {
            throw new UsernameNotFoundException("More than one user with username " + username + ". Database may be corrupted", (Throwable)exc);
        }
    }
}

