/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jcommon.persistence;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import javax.persistence.AttributeConverter;

public abstract class ListOfToStringAttributeConverter<T>
implements AttributeConverter<ArrayList<T>, String> {
    private AttributeConverter<T, String> itemConverter;
    private String separator;
    private Function<T, String> convertItemToDatabaseColumn = new Function<T, String>(){

        public String apply(T input) {
            return (String)ListOfToStringAttributeConverter.this.itemConverter.convertToDatabaseColumn(input);
        }
    };
    private Function<String, T> convertToItem = new Function<String, T>(){

        public T apply(String input) {
            return ListOfToStringAttributeConverter.this.itemConverter.convertToEntityAttribute((Object)input);
        }
    };

    public ListOfToStringAttributeConverter(AttributeConverter<T, String> itemConverter, String separator) {
        this.itemConverter = itemConverter;
        this.separator = separator;
    }

    public String getSeparator() {
        return this.separator;
    }

    public String convertToDatabaseColumn(ArrayList<T> attributeObject) {
        return attributeObject == null ? null : Joiner.on((String)this.getSeparator()).join(Iterables.transform(attributeObject, this.convertItemToDatabaseColumn));
    }

    public ArrayList<T> convertToEntityAttribute(String datastoreValue) {
        if (datastoreValue == null) {
            return null;
        }
        ArrayList values = new ArrayList();
        if (datastoreValue.length() == 0) {
            return values;
        }
        Iterables.addAll(values, (Iterable)Iterables.transform((Iterable)Splitter.on((String)this.getSeparator()).split((CharSequence)datastoreValue), this.convertToItem));
        return values;
    }
}

