/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jcommon.persistence;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.AttributeConverter;
import javax.persistence.Converter;

@Converter
public class ListOfStringsToStringAttributeConverter
implements AttributeConverter<List<String>, String> {
    private static final String DEFAULT_SEPARATOR = ",";

    public String getSeparator() {
        return DEFAULT_SEPARATOR;
    }

    public String convertToDatabaseColumn(List<String> attributeObject) {
        return attributeObject == null ? null : Joiner.on((String)this.getSeparator()).join(attributeObject);
    }

    public List<String> convertToEntityAttribute(String datastoreValue) {
        if (datastoreValue == null) {
            return null;
        }
        ArrayList<String> values = new ArrayList<String>();
        if (datastoreValue.length() == 0) {
            return values;
        }
        Iterables.addAll(values, (Iterable)Splitter.on((String)this.getSeparator()).split((CharSequence)datastoreValue));
        return values;
    }
}

