/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jcommon.persistence;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.HashSet;
import javax.persistence.AttributeConverter;
import javax.persistence.Converter;
import net.sf.jcommon.persistence.GrantedAuthorityToStringAttributeConverter;
import org.springframework.security.core.GrantedAuthority;

@Converter
public class CollectionOfGrantedAuthorityToStringAttributeConverter
implements AttributeConverter<Collection<GrantedAuthority>, String> {
    private AttributeConverter<GrantedAuthority, String> itemConverter;
    private String separator;
    private Function<GrantedAuthority, String> convertItemToDatabaseColumn = new Function<GrantedAuthority, String>(){

        public String apply(GrantedAuthority input) {
            return (String)CollectionOfGrantedAuthorityToStringAttributeConverter.this.itemConverter.convertToDatabaseColumn((Object)input);
        }
    };
    private Function<String, GrantedAuthority> convertToItem = new Function<String, GrantedAuthority>(){

        public GrantedAuthority apply(String input) {
            return (GrantedAuthority)CollectionOfGrantedAuthorityToStringAttributeConverter.this.itemConverter.convertToEntityAttribute((Object)input);
        }
    };

    public CollectionOfGrantedAuthorityToStringAttributeConverter() {
        this(new GrantedAuthorityToStringAttributeConverter(), ",");
    }

    public CollectionOfGrantedAuthorityToStringAttributeConverter(AttributeConverter<GrantedAuthority, String> itemConverter, String separator) {
        this.itemConverter = itemConverter;
        this.separator = separator;
    }

    public String getSeparator() {
        return this.separator;
    }

    public String convertToDatabaseColumn(Collection<GrantedAuthority> attributeObject) {
        return attributeObject == null ? null : Joiner.on((String)this.getSeparator()).join(Iterables.transform(attributeObject, this.convertItemToDatabaseColumn));
    }

    public Collection<GrantedAuthority> convertToEntityAttribute(String datastoreValue) {
        if (datastoreValue == null) {
            return null;
        }
        HashSet<GrantedAuthority> values = new HashSet<GrantedAuthority>();
        if (datastoreValue.length() == 0) {
            return values;
        }
        Iterables.addAll(values, (Iterable)Iterables.transform((Iterable)Splitter.on((String)this.getSeparator()).split((CharSequence)datastoreValue), this.convertToItem));
        return values;
    }
}

