/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jcommon.persistence;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import javax.persistence.AttributeConverter;

public abstract class CollectionOfEnumsToStringAttributeConverter<T extends Enum<T>, C extends Collection<T>>
implements AttributeConverter<C, String> {
    private static final String DEFAULT_SEPARATOR = ",";
    private Class<T> enumClass;

    public CollectionOfEnumsToStringAttributeConverter() {
        Type superClass = this.getClass().getGenericSuperclass();
        this.enumClass = (Class)((ParameterizedType)superClass).getActualTypeArguments()[0];
    }

    public String getSeparator() {
        return DEFAULT_SEPARATOR;
    }

    public String convertToDatabaseColumn(C attributeObject) {
        return attributeObject == null ? null : Joiner.on((String)this.getSeparator()).join(attributeObject);
    }

    public C convertToEntityAttribute(String datastoreValue) {
        if (datastoreValue == null) {
            return null;
        }
        C values = this.createCollection();
        if (datastoreValue.length() == 0) {
            return values;
        }
        for (String s : Splitter.on((String)this.getSeparator()).split((CharSequence)datastoreValue)) {
            T e = Enum.valueOf(this.enumClass, s);
            if (e == null) continue;
            values.add(e);
        }
        return values;
    }

    protected abstract C createCollection();
}

