/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jcommon.persistence;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import javax.persistence.AttributeConverter;
import javax.persistence.Converter;

@Converter
public class ArrayOfStringsToStringAttributeConverter
implements AttributeConverter<String[], String> {
    private static final String DEFAULT_SEPARATOR = ",";

    public String getSeparator() {
        return DEFAULT_SEPARATOR;
    }

    public String convertToDatabaseColumn(String[] attributeObject) {
        return attributeObject == null ? null : Joiner.on((String)this.getSeparator()).join((Object[])attributeObject);
    }

    public String[] convertToEntityAttribute(String datastoreValue) {
        if (datastoreValue == null) {
            return null;
        }
        if (datastoreValue.length() == 0) {
            return new String[0];
        }
        return (String[])Iterables.toArray((Iterable)Splitter.on((String)this.getSeparator()).split((CharSequence)datastoreValue), String.class);
    }
}

