/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jcommon.io;

import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;

public final class ReplaceTokensWriter
extends Writer {
    private static final char DEFAULT_BEGIN_TOKEN = '@';
    private static final char DEFAULT_END_TOKEN = '@';
    private Map<String, String> tokens = new HashMap<String, String>();
    private char beginToken = (char)64;
    private char endToken = (char)64;
    private Writer out;
    StringBuffer buff = new StringBuffer();
    boolean inToken = false;

    public ReplaceTokensWriter(Writer out) {
        this.out = out;
    }

    @Override
    public void write(int c) throws IOException {
        if (!this.inToken) {
            if (c == this.beginToken) {
                this.inToken = true;
            } else {
                this.out.write((char)c);
            }
        } else if (c == this.endToken) {
            String s = this.buff.toString();
            String value = this.tokens.get(s);
            s = value != null ? value.toString() : String.valueOf(this.beginToken) + s + this.endToken;
            this.out.write(s);
            this.buff.setLength(0);
            this.inToken = false;
        } else {
            this.buff.append((char)c);
        }
    }

    @Override
    public void flush() throws IOException {
        this.out.flush();
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        int i = off;
        while (i < cbuf.length && i < off + len) {
            this.write(cbuf[i]);
            ++i;
        }
    }

    @Override
    public void write(char[] cbuf) throws IOException {
        this.write(cbuf, 0, cbuf.length);
    }

    @Override
    public void write(String str) throws IOException {
        this.write(str.toCharArray());
    }

    @Override
    public void write(String str, int off, int len) throws IOException {
        this.write(str.toCharArray(), off, len);
    }

    @Override
    public void close() throws IOException {
        this.out.close();
    }

    public void setBeginToken(char beginToken) {
        this.beginToken = beginToken;
    }

    public char getBeginToken() {
        return this.beginToken;
    }

    public void setEndToken(char endToken) {
        this.endToken = endToken;
    }

    public char getEndToken() {
        return this.endToken;
    }

    public void addToken(String key, String value) {
        this.tokens.put(key, value);
    }

    public void addTokens(Map<String, String> tokens) {
        this.tokens.putAll(tokens);
    }
}

