/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jcommon.io;

import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;

public final class ReplaceTokensReader
extends Reader {
    private static final char DEFAULT_BEGIN_TOKEN = '@';
    private static final char DEFAULT_END_TOKEN = '@';
    private String queuedData = null;
    private String replaceData = null;
    private int replaceIndex = -1;
    private int queueIndex = -1;
    private Map<String, String> tokens = new HashMap<String, String>();
    private char beginToken = (char)64;
    private char endToken = (char)64;
    private Reader in;

    public ReplaceTokensReader(Reader in) {
        this.in = in;
    }

    private int getNextChar() throws IOException {
        if (this.queueIndex != -1) {
            char ch = this.queuedData.charAt(this.queueIndex++);
            if (this.queueIndex >= this.queuedData.length()) {
                this.queueIndex = -1;
            }
            return ch;
        }
        return this.in.read();
    }

    @Override
    public final int read() throws IOException {
        if (this.replaceIndex != -1) {
            char ch = this.replaceData.charAt(this.replaceIndex++);
            if (this.replaceIndex >= this.replaceData.length()) {
                this.replaceIndex = -1;
            }
            return ch;
        }
        int ch = this.getNextChar();
        if (ch == this.beginToken) {
            StringBuffer key = new StringBuffer("");
            while ((ch = this.getNextChar()) != -1) {
                key.append((char)ch);
                if (ch != this.endToken) continue;
            }
            if (ch == -1) {
                this.queuedData = this.queuedData == null || this.queueIndex == -1 ? key.toString() : String.valueOf(key.toString()) + this.queuedData.substring(this.queueIndex);
                this.queueIndex = 0;
                return this.beginToken;
            }
            key.setLength(key.length() - 1);
            String replaceWith = this.tokens.get(key.toString());
            if (replaceWith != null) {
                if (replaceWith.length() > 0) {
                    this.replaceData = replaceWith;
                    this.replaceIndex = 0;
                }
                return this.read();
            }
            String newData = String.valueOf(key.toString()) + this.endToken;
            this.queuedData = this.queuedData == null || this.queueIndex == -1 ? newData : String.valueOf(newData) + this.queuedData.substring(this.queueIndex);
            this.queueIndex = 0;
            return this.beginToken;
        }
        return ch;
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        return this.in.read(cbuf, off, len);
    }

    public void setBeginToken(char beginToken) {
        this.beginToken = beginToken;
    }

    public char getBeginToken() {
        return this.beginToken;
    }

    public void setEndToken(char endToken) {
        this.endToken = endToken;
    }

    public char getEndToken() {
        return this.endToken;
    }

    public void addToken(String key, String value) {
        this.tokens.put(key, value);
    }
}

