/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jcommon.io;

import java.awt.Component;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.swing.ProgressMonitor;

public class ProgressMonitorOutputStream
extends FilterOutputStream {
    private ProgressMonitor monitor;
    private int nwritten = 0;

    public ProgressMonitorOutputStream(Component parentComponent, Object message, OutputStream out, int totalSize) {
        super(out);
        this.monitor = new ProgressMonitor(parentComponent, message, null, 0, totalSize);
    }

    public ProgressMonitor getProgressMonitor() {
        return this.monitor;
    }

    @Override
    public void close() throws IOException {
        this.out.close();
        this.monitor.close();
    }

    @Override
    public void flush() throws IOException {
        if (this.monitor.isCanceled()) {
            this.close();
            return;
        }
        this.out.flush();
    }

    @Override
    public void write(int b) throws IOException {
        if (this.monitor.isCanceled()) {
            this.close();
            return;
        }
        this.out.write(b);
        ++this.nwritten;
        this.monitor.setProgress(this.nwritten);
    }

    @Override
    public void write(byte[] b) throws IOException {
        if (this.monitor.isCanceled()) {
            this.close();
            return;
        }
        this.out.write(b);
        this.nwritten += b.length;
        this.monitor.setProgress(this.nwritten);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (this.monitor.isCanceled()) {
            this.close();
            return;
        }
        this.out.write(b, off, len);
        this.nwritten += len;
        this.monitor.setProgress(this.nwritten);
    }
}

