/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jcommon.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;

public class InterruptibleInputStream
extends InputStream {
    private IOException interrupted;
    private InputStream in;

    public InterruptibleInputStream(InputStream in) {
        this.in = in;
    }

    @Override
    public int read() throws IOException {
        if (this.interrupted != null) {
            throw this.interrupted;
        }
        return this.in.read();
    }

    @Override
    public int available() throws IOException {
        if (this.interrupted != null) {
            throw this.interrupted;
        }
        return this.in.available();
    }

    @Override
    public void close() throws IOException {
        if (this.interrupted != null) {
            this.in.close();
        }
    }

    @Override
    public synchronized void reset() throws IOException {
        if (this.interrupted != null) {
            throw this.interrupted;
        }
        this.in.reset();
    }

    @Override
    public boolean markSupported() {
        return this.in.markSupported();
    }

    @Override
    public synchronized void mark(int readlimit) {
        this.in.mark(readlimit);
    }

    @Override
    public long skip(long n) throws IOException {
        if (this.interrupted != null) {
            throw this.interrupted;
        }
        return this.in.skip(n);
    }

    @Override
    public int read(byte[] b) throws IOException {
        if (this.interrupted != null) {
            throw this.interrupted;
        }
        return this.in.read(b);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.interrupted != null) {
            throw this.interrupted;
        }
        return this.in.read(b, off, len);
    }

    public boolean isInterrupted() {
        return this.interrupted != null;
    }

    public void interrupt() {
        this.interrupt(new InterruptedIOException());
    }

    public void interrupt(IOException exc) {
        if (this.interrupted != null) {
            throw new IllegalStateException("Input stream already interrupted.");
        }
        this.interrupted = exc;
        try {
            this.in.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

