/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jcommon.geo.format;

import java.text.ParseException;
import java.util.Locale;
import java.util.regex.Pattern;
import org.springframework.format.Formatter;

public class LocaleFormatter
implements Formatter<Locale> {
    private static Pattern L = Pattern.compile("(\\b)(l|L)(\\b)");
    private static Pattern LL = Pattern.compile("(\\b)(l|L){2}(\\b)");
    private static Pattern LLL = Pattern.compile("(\\b)(l|L){3}(\\b)");
    private static Pattern C = Pattern.compile("(\\b)(c|C)(\\b)");
    private static Pattern CC = Pattern.compile("(\\b)(c|C){2}(\\b)");
    private static Pattern CCC = Pattern.compile("(\\b)(c|C){3}(\\b)");
    private String pattern;

    public LocaleFormatter(String pattern) {
        this.pattern = pattern;
    }

    public LocaleFormatter() {
        this("L-C");
    }

    public String print(Locale locale, Locale inLocale) {
        String s = this.pattern;
        s = L.matcher(s).replaceAll("${1}" + locale.getDisplayLanguage(inLocale) + "${3}");
        s = LL.matcher(s).replaceAll("${1}" + locale.getLanguage() + "${3}");
        s = LLL.matcher(s).replaceAll("${1}" + locale.getISO3Language() + "${3}");
        s = C.matcher(s).replaceAll("${1}" + locale.getDisplayCountry(inLocale) + "${3}");
        s = CC.matcher(s).replaceAll("${1}" + locale.getCountry() + "${3}");
        s = CCC.matcher(s).replaceAll("${1}" + locale.getISO3Country() + "${3}");
        return s;
    }

    public Locale parse(String text, Locale inLocale) throws ParseException {
        throw new UnsupportedOperationException("Please use this formatter only as a printer.CountryFormatter.java");
    }
}

