/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jcommon.geo.format;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.springframework.context.MessageSource;
import org.springframework.context.NoSuchMessageException;
import org.springframework.format.Formatter;

public class DateFormatter
implements Formatter<Date> {
    private MessageSource messageSource;
    private String dateFormatMessageKey;

    public DateFormatter(MessageSource messageSource) {
        this(messageSource, "date.format");
    }

    public DateFormatter(MessageSource messageSource, String messageKey) {
        this.messageSource = messageSource;
        this.dateFormatMessageKey = messageKey;
    }

    public Date parse(String text, Locale locale) throws ParseException {
        SimpleDateFormat dateFormat = this.createDateFormat(locale);
        return dateFormat.parse(text);
    }

    public String print(Date object, Locale locale) {
        SimpleDateFormat dateFormat = this.createDateFormat(locale);
        return dateFormat.format(object);
    }

    private SimpleDateFormat createDateFormat(Locale locale) {
        SimpleDateFormat dateFormat;
        try {
            dateFormat = new SimpleDateFormat(this.messageSource.getMessage(this.dateFormatMessageKey, null, locale), locale);
        }
        catch (NoSuchMessageException exc) {
            dateFormat = new SimpleDateFormat();
        }
        dateFormat.setLenient(false);
        return dateFormat;
    }
}

