/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jcommon.geo.format;

import com.google.common.collect.Iterables;
import java.text.ParseException;
import java.util.Locale;
import net.sf.jcommon.geo.Country;
import net.sf.jcommon.geo.CountryPredicates;
import org.springframework.format.Formatter;

public class CountryFormatter
implements Formatter<Country> {
    public String print(Country country, Locale inLocale) {
        return country.getDisplayName(inLocale);
    }

    public Country parse(String text, Locale inLocale) throws ParseException {
        Country country = (Country)Iterables.find(Country.getCountries(), CountryPredicates.displayName(text, inLocale));
        if (country == null) {
            throw new ParseException("Country name " + text + " is not a valid name in locale " + inLocale, 0);
        }
        return country;
    }
}

